package com.xunlei.niux.client.xiaojinku;

import java.util.HashMap;
import java.util.Map;

import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

/**
 * 向小金库发放Vip
 * @author linzhijun
 * 接口描述如下：
author:张天华
2013-1-19

[host]
10.10.20.101 dynamic.vip.xunlei.com


[接口地址]
http://dynamic.vip.xunlei.com/xljinku/vip/?uid=*&orderid=*&act=*&type=vip&num1=1&sign=*
参数说明：
	uid: 迅雷UID
	orderid: 订单号，唯一性
	act: 活动标识，由开发分配
	type: 开通类型：vip 普通会员；baijin 白金会员
	num1: 开通月份，可选1，3，6，12（白金会员可选1，3，12）
	sign: 签名，见【签名规则】

[返回值]
成功：
	ret=0&error=
失败：
	ret=1&error=*

返回说明：
ret=0 成功
ret=1 参数错误
ret=2 无效的月份
ret=3 订单号重复
ret=5 迅雷帐号不存在
ret=11 无效的商户
ret=12 IP请求无效
ret=13 签名错误
ret=14 达到了当天领取上限


[签名规则]

将HTTP请求中传递的所有参数（sign除外）按照名称字段升序顺序串联起来。
如p1=v1&p2=v2&p3=v3，构成待签名数据。
签名结果为 sign= md5( 待签名数据 + 密钥 )
注：没有值的参数无须传递，签名密钥请联系李东旭提供

签名算法：（PHP版本）
$data = $_GET;
function sign($data , $key){
	if (isset($data['sign'])) unset($data['sign']);
	ksort($data);
	$query = http_build_query($data);
	return md5($query . $key);
}


[安全限制]
接口有商户接入限制，需要先提供服务器请求ip，在会员运营后台配置，请联系李东旭。
活动标识：5002-5999

[内网测试配置]
标识：5001
密钥：j434cTB9(dvlk!kfOe
请求服务器IP: 请提供


[测试]

请求：
http://dynamic.vip.xunlei.com/xljinku/vip/?uid=501&orderid=2013012100002&act=5001&type=vip&num1=1&sign=99922e737fca61eef6cd19d91a388172

签名字符串序列：
act=5001&expire=31&num1=1&orderid=2013012100002&type=vip&uid=501

签名结果：
99922e737fca61eef6cd19d91a388172
 */
public class GiveOutVip {
//	private  static Logger logger=Logger.getLogger(GiveOutVip.class.getName());
	private static String XiaoJinKu_URL= EnvPropertyUtil.loadProperty("niuxclient", "xiaojianku_url", "http://dynamic.vip.xunlei.com");
	private static String XiaoJinKu_actPwd=EnvPropertyUtil.loadProperty("niuxclient", "XiaoJinKu_actPwd","j434cTB9(dvlk!kfOe");
	private static String XiaoJinKu_actNo=EnvPropertyUtil.loadProperty("niuxclient", "XiaoJinKu_actNo","5001");
	
	public static void giveOut(long uid,String orderId,String type,int num){
		if(StringUtil.isEmpty(orderId,type)){
			throw new RuntimeException("发放小金库参数为空");
		}
		//判断会员类型
		if(!isValidVipType(type)){
			throw new RuntimeException("错误的会员类型["+type+"]");
		}
		//判断会员类型与会员数目是否合法
		if(!isValidVipNum(type, num)){
			throw new RuntimeException("会员类型["+type+"]与数量["+num+"]不匹配");
		}
		Map<String,String> map=new HashMap<String,String>();
		map.put("act", XiaoJinKu_actNo);
		map.put("num1", num+"");
		map.put("orderid", orderId);
		map.put("type", type);
		map.put("uid", uid+"");
		String sign=SignUtil.sign(map, XiaoJinKu_actPwd);
		String param=SignUtil.getSignatureContent(map);
		StringBuilder sb=new StringBuilder();
		sb.append(XiaoJinKu_URL+"/xljinku/vip/?").append(param).append("&sign=").append(sign);
		//logger.info("小金库请求："+sb.toString());
		String respStr=URLUtil.get(sb.toString());
		//logger.info("小金库响应："+respStr);
		//判断响应是否有效（按照文档格式为有效）
		if(!isValidResp(respStr)){
			throw new RuntimeException("响应格式非法");
		}
		if(!isSucces(respStr)){
			throw new RuntimeException("发放失败，响应内容："+respStr);
		}
	}
	private static boolean isValidResp(String resp){
		if(resp.contains("ret=")){
			return true;
		}
		return false;
	}
	/**
	 * 操作是否成功
	 * @param resp
	 * @return
	 */
	private static boolean isSucces(String resp){
		if(resp.contains("ret=0&")){
			return true;
		}
		if(resp.contains("ret=3&")){
			return true;
		}
		return false;
	}
	/**
	 * 判断会员类型是否合法
	 */
	private static boolean isValidVipType(String type){
		if("vip".equals(type)||"baijin".equals(type)){
			return true;
		}
		return false;
	}
	/**
	 * 判断会员数量是否合法
	 */
	private static boolean isValidVipNum(String type,int num){
		if("vip".equals(type)){
			switch (num) {
			case 1:
			case 3:
			case 6:
			case 12:
					return true;
			default:
				return false;
			}
		}else{
			switch (num) {
			case 1:
			case 3:
			case 12:
					return true;
			default:
				return false;
			}
		}
	}
}
