package com.xunlei.niux.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
	/**
	 * json字符串转化为object对象，{}转化为map,[]转化为list
	 * @param jsonString
	 * @return
	 * @throws Exception
	 */
	public static Object jsonToObject(String jsonString) throws Exception{
		JsonToObject jto=new JsonToObject(jsonString);
		return jto.jsonToObject();
	}
	
	

	/**
	 * json转化为对象
	 * @author Administrator
	 *
	 */
	private static class JsonToObject {
		private String value;
		private int beginIndex;
		public JsonToObject(String value){
			this.value=value;
			beginIndex=0;
		}
		/**
		 * json字符串转化为对象
		 * {}转化为map；[]转化为List
		 * @return 
		 * @throws Exception
		 */
		public Object jsonToObject()throws Exception{
			if(value==null||"".equals(value)){
				return value;
			}
			try {
				Object o=getObject();
				beginIndex=0;//归零
				return o;
			} catch (Exception e) {
				beginIndex=0;//归零
				throw e;
			}
		}
		/**
		 * 将json字符串转化为对象{"key1":true}
		 * @param jsonStr
		 * @return
		 */
		private Map<String,Object> getMap()throws Exception{
			Map<String,Object> map=new HashMap<String,Object>();
			if('{'!=value.charAt(beginIndex)){//map格式以左大括号开始
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			if('}'==value.charAt(beginIndex)){
				beginIndex++;
				return map;
			}
			while(beginIndex<value.length()){
				String key=getString();
				if(':'!=value.charAt(beginIndex)){
					throw new Exception("json不正确");
				}
				else{
					beginIndex++;
				}
				Object o=getObject();
				map.put(key, o);
				if('}'==value.charAt(beginIndex)){//map结束
					break;
				}
				//map以,分割
				if(','!=value.charAt(beginIndex)){
					//实际代码中不是以,分割，不符合json格式
					throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
				}
				beginIndex++;
			}
			if('}'!=value.charAt(beginIndex)){//重新确认map是否以}结束
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			return map;
		}
		/**
		 * 获取字符串
		 * @return
		 * @throws Exception
		 */
		private String getString()throws Exception{
			StringBuilder sb=new StringBuilder();
			if('\"'!=value.charAt(beginIndex)){//字符串以双引号开始
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			while(true){
				if('\\'==value.charAt(beginIndex))
				{
					sb.append(value.charAt(beginIndex));
					sb.append(value.charAt(beginIndex+1));
					beginIndex=beginIndex+2;
					continue;
				}
				if('\"'==value.charAt(beginIndex)){
					break;
				}
				sb.append(value.charAt(beginIndex));
				beginIndex++;
			}
			if('\"'!=value.charAt(beginIndex)){
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			return sb.toString();
		}
		private List<Object> getList()throws Exception{
			//以[开头判断
			if('['!=value.charAt(beginIndex)){
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			List<Object> list=new ArrayList<Object>();
			if(']'==value.charAt(beginIndex)){//结束
				beginIndex++;
				return list;
			}
			//处理其他业务
			while(beginIndex<value.length()){
				Object o=getObject();
				list.add(o);
				//判断是否结束
				if(']'==value.charAt(beginIndex)){
					break;
				}
				//判断分割符
				if(','!=value.charAt(beginIndex)){
					throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
				}
				beginIndex++;
			}
			//以]结束判断
			if(']'!=value.charAt(beginIndex)){
				throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
			}
			beginIndex++;
			return list;
		}
		//获取json字符串转化后的对象
		private Object getObject()throws Exception{
			char c=value.charAt(beginIndex);
			if('"'==c){//数组处理
				return getString();
			}
			if('['==c){//数组处理
				return getList();
			}
			if('{'==c)//集合处理
			{
				return getMap();
			}
			if('n'==c){//null处理
				beginIndex=beginIndex+4;
				return null;
			}
			if('t'==c){//true
				beginIndex=beginIndex+4;
				return true;
			}
			if('f'==c){//false
				beginIndex=beginIndex+5;
				return true;
			}
			return getNumber();
			//throw new Exception("json格式不正确,第"+beginIndex+"字符不符合");
		}
		private String getNumber()throws Exception{
			String str="";
			while(true){
				char c=value.charAt(beginIndex);
				if(c>='0'&&c<='9'){
					str=str+c;
				}else if (c=='.'){
					str=str+c;
				}else if (c=='-'){
					str=str+c;
				}else{
					break;
				}
				beginIndex++;
			}
			Double.valueOf(str);
			return str;
		}
	}
}
