package com.xunlei.niux.client.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeDTO;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import org.apache.log4j.Logger;

import java.lang.reflect.Type;
import java.util.*;


/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-7
 * Time: 上午11:20
 * To change this template use File | Settings | File Templates.
 */
public class PrivilegeClient {
    private static final Logger logger = Logger.getLogger(PrivilegeClient.class);
    private final static String PrivilegeUrl = "http://jinzuan.niu.xunlei.com:9090/privilege/";
    private final static String priKey = EnvPropertyUtil.loadProperty("niuxclient","PrivilegeClient_priKey");




    //用户是否可以使用某项特权
    public static Map<String ,Object> haveUnusedPrivilege(String userId, PrivilegeType pritype){
        String url = PrivilegeUrl + "receive.do?";
        url += "uid="+userId;
        url += "&ptype="+pritype.getValue();
        logger.info("haveUnusedPrivilege request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("haveUnusedPrivilege request response: "+resp);
        Gson gson = new Gson();

        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map<String, Object> myMap = gson.fromJson(resp, type);

        return myMap;
    }

    public static String usePrivilege(String userId, PrivilegeType pritype, int useCount){
        String url = PrivilegeUrl + "use.do?";

        String timestamp = String.valueOf(new Date().getTime());
        url += "uid="+userId;
        url += "&ptype="+pritype.getValue();
        url += "&timestamp="+ timestamp;
        url += "&usedValue="+useCount;

        String sign = Md5Encrypt.md5(userId+pritype.getValue()+useCount+timestamp+priKey);

        url += "&sign="+sign;

//        Map<String, String> param = new HashMap<String, String>();
//        param.put("uid", userId);
//        param.put("ptype", String.valueOf(pritype.getValue()));
//        param.put("timestamp", String.valueOf(new Date().getTime()));
//        param.put("usedValue", String.valueOf(useCount));
//
//        String sign = SignUtil.sign(param, Key);
//        param.put("sign",sign);
//
//        String paramStr=SignUtil.getSignatureContent(param);
//        url += paramStr;

        logger.info("usePrivilege request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("usePrivilege request response: "+resp);


        return resp;
    }

    //签到可获得积分接口
    public static Map<String,Object> signInGetBonusNum(String userId){
        String url = PrivilegeUrl + "getBonus.do?";
        url += "uid="+userId;

        logger.info("signInGetBonusNum request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("signInGetBonusNum request response: "+resp);

        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = jsonObject.get("rtn").getAsInt();
        if(rtnCode == 0){
            JsonObject dataObj = jsonObject.getAsJsonObject("data");
            int bonusNum = dataObj.get("value").getAsInt();
            return MapEasyUtils.generateMap(MapEasyUtils.SUCCESS, bonusNum);
        }

        return MapEasyUtils.generateMap(-1,resp);
    }


    //获取所有特权基本信息
    public static String getAllPrivilegeInfo(){
        Map<String,Object> resultMap = new HashMap<String, Object>();

        String url = PrivilegeUrl + "privilegeinfo.do";

        logger.info("getAllPrivilegeInfo request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getAllPrivilegeInfo request response: "+resp);

//        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
//        int rtnCode = jsonObject.get("rtn").getAsInt();
//        if (rtnCode == 0){
//            Gson gson = new Gson();
//            Type type = new TypeToken<List<PrivilegeDTO>>(){}.getType();
//            List<PrivilegeDTO> priInfoList = gson.fromJson(jsonObject.get("data"), type);
//            resultMap.put("code",rtnCode);
//            resultMap.put("data",priInfoList);
//        }else {
//            resultMap.put("code",rtnCode);
//            resultMap.put("data",jsonObject.get("data"));
//        }

        return resp;
    }

    public static Map<String,Object> getPrivilegeLevelInfo(PrivilegeType privilegeType){
        Map<String,Object> resultMap = new HashMap<String, Object>();

        String url = PrivilegeUrl + "getPrivilege.do?";
        url += "ptype="+privilegeType.getValue();

        logger.info("getPrivilegeLevelInfo request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getPrivilegeLevelInfo request response: "+resp);
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = jsonObject.get("rtn").getAsInt();

        if(rtnCode==0){
            Gson gson = new Gson();
            Type type = new TypeToken<List<PrivilegeDTO>>(){}.getType();
            List<PrivilegeDTO> priInfoList = gson.fromJson(jsonObject.get("data"), type);
            resultMap.put("code",rtnCode);
            resultMap.put("data",priInfoList);
        }else {
            resultMap.put("code",rtnCode);
            resultMap.put("data",jsonObject.get("data"));
        }

        return resultMap;
    }




}
