package com.xunlei.niux.client.daijinquan;

import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by admin on 15-5-25.
 */
public class NiuXCashClient {
    private static final Logger logger = Log.getLogger(NiuXCashClient.class);
    private static String baseUrl = "http://dy.niu.xunlei.com/league/generatecash.do?";
    private static String generatePrivateKey="wlssfldflinlfslfs";

    public static String generateCash(String generateNo,String userId,String actNo){
        Map<String,String> paramMap = new HashMap<String, String>();
        paramMap.put("generateNo",generateNo);
        paramMap.put("receiveUserId",userId);
        paramMap.put("bizNo", "");
        String sign = SignUtil.sign(paramMap,generatePrivateKey);

        paramMap.put("sign",sign);
        paramMap.put("actNo",actNo);
        paramMap.put("resptype","plain");

        String orderId = actNo+System.currentTimeMillis();
        paramMap.put("orderId",orderId);

        String url = baseUrl + SignUtil.getSignatureContent(paramMap);

        logger.info("generateCash request url: {}",url);
        String resp = HttpClientUtil.get(url);
        logger.info("generateCash response: {}",resp);

        return resp;
    }

    public static String generateCash(String generateNo,String userId,String actNo,String gameId){
        Map<String,String> paramMap = new HashMap<String, String>();
        paramMap.put("generateNo",generateNo);
        paramMap.put("receiveUserId",userId);
        paramMap.put("bizNo", actNo);
        paramMap.put("gameid", gameId);
        String sign = SignUtil.sign(paramMap,generatePrivateKey);

        paramMap.put("sign",sign);
        paramMap.put("actNo",actNo);
        paramMap.put("resptype","plain");

        String orderId = actNo+System.currentTimeMillis();
        paramMap.put("orderid",orderId);

        String url = baseUrl + SignUtil.getSignatureContent(paramMap);

        logger.info("generateCash request url: {}",url);
        String resp = HttpClientUtil.get(url);
        logger.info("generateCash response: {}",resp);

        return resp;
    }

}
