package com.xunlei.niux.client.util;

import java.util.ResourceBundle;

import org.slf4j.Logger;

import com.xunlei.util.Log;

public class RBundleUtil {
	private static Logger logger = Log.getLogger(RBundleUtil.class);
	public static String getString(String propertiesFileName,String keyName){
		try{
			ResourceBundle rb=ResourceBundle.getBundle(propertiesFileName);
			return rb.getString(keyName);
		}catch(Exception e){
			logger.error("配置文件{"+propertiesFileName+"}key{"+keyName+"}不存在",e);
			return "";
		}
		
	}
	public static String getString(String propertiesFileName,String keyName,String defaultValue){
		String value="";
		try{
			value=getString(propertiesFileName, keyName);
		}catch(Exception e){
			
		}
		return StringUtil.isEmpty(value)?defaultValue:value;
	}
}
