package com.xunlei.niux.client.jinzuan;

import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;

/**
 * Created by jamesjxin on 14-3-28.
 */
public class CommonActivityClient {
    private static final Logger logger = Log.getLogger(CommonActivityClient.class);
    private final static String ActivityUrl = "http://activity.niu.xunlei.com:8090/commonactivity/";
    private final static String authId = ResourceBundle.getBundle("niuxclient").getString("CommonActivityClient_authId");
    private final static String SignKey = ResourceBundle.getBundle("niuxclient").getString("CommonActivityClient_SignKey");

    public static String isUserCanUseActAllModule(String actNo,String moduleId,String userId){

        String url = ActivityUrl + "isUserCanUseActAllModule.do?";
        url += "actno="+actNo+"&userid="+userId;
        if(StringUtils.isNotEmpty(moduleId)){
            url += "&moduleid="+moduleId;
        }
        url += "&isJinZuan=1";

        logger.info("isUserCanUseActAllModule request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("isUserCanUseActAllModule request response: "+resp);

        return resp;
    }

    public static String getGift(String actNo,String moduleId,String userId,String giftId,String remoteIp){

        return getGift(actNo, moduleId, userId, giftId, remoteIp, true);
    }

    public static String getGift(String actNo,String moduleId,String userId,String giftId,String remoteIp,boolean isJinzuan){

        String url = ActivityUrl + "getGift_v2.do?";

        Map param = new HashMap();
        param.put("userid",userId);
        param.put("actno", actNo);
        if(!StringUtils.isEmpty(moduleId)){
            param.put("moduleid",moduleId);
        }
        if(!StringUtils.isEmpty(remoteIp)){
            param.put("ip",remoteIp);
        }
        param.put("isjinzuan",isJinzuan?"1":"0");
        param.put("authid",authId);
        param.put("giftid",giftId);
        //orderid规则：活动编号＋userId＋giftId＋时间戳（秒）
        Random random = new Random(System.currentTimeMillis());
        String orderId = actNo+System.currentTimeMillis()/1000+random.nextInt(100000);
        param.put("orderid",orderId);

        String sign = SignUtil.sign(param, SignKey);
        param.put("sign",sign);
        String paramStr = SignUtil.getSignatureContent(param);

        url += paramStr;

        logger.info("getGift request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGift request response: "+resp);

        return resp;
    }

    public static String getGiftInfoList(String actNo,String moduleId){
        String url = ActivityUrl + "getGiftInfo.do?";

        url += "actno="+actNo;
        if(StringUtils.isNotEmpty(moduleId)){
            url += "&moduleid="+moduleId;
        }

        logger.info("getGiftInfoList request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGiftInfoList request response: "+resp);

        return resp;
    }

    public static String isGameHasGiftPackage(String gameId){
        String url = ActivityUrl + "isGameHasGiftPackage.do?";
        url += "gameid="+gameId;

        logger.info("getGift request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGift request response: "+resp);

        return resp;
    }

}
