/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.springframework.util.xml.TransformerUtils;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.util.NestedServletException;
import org.w3c.dom.Node;

public abstract class AbstractXsltView
extends AbstractView {
    public static final String XML_CONTENT_TYPE = "text/xml;charset=ISO-8859-1";
    public static final String DEFAULT_ROOT = "DocRoot";
    private boolean customContentTypeSet = false;
    private Class transformerFactoryClass;
    private Resource stylesheetLocation;
    private String root = "DocRoot";
    private boolean useSingleModelNameAsRoot = true;
    private URIResolver uriResolver;
    private ErrorListener errorListener = new SimpleTransformErrorListener(this.logger);
    private boolean indent = true;
    private Properties outputProperties;
    private boolean cache = true;
    private TransformerFactory transformerFactory;
    private volatile Templates cachedTemplates;

    protected AbstractXsltView() {
        super.setContentType(XML_CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        this.customContentTypeSet = true;
    }

    public void setTransformerFactoryClass(Class transformerFactoryClass) {
        Assert.isAssignable(TransformerFactory.class, transformerFactoryClass);
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public void setStylesheetLocation(Resource stylesheetLocation) {
        this.stylesheetLocation = stylesheetLocation;
        this.resetCachedTemplates();
    }

    protected Resource getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setUseSingleModelNameAsRoot(boolean useSingleModelNameAsRoot) {
        this.useSingleModelNameAsRoot = useSingleModelNameAsRoot;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public final void resetCachedTemplates() {
        this.cachedTemplates = null;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        this.transformerFactory = this.newTransformerFactory(this.transformerFactoryClass);
        this.transformerFactory.setErrorListener(this.errorListener);
        if (this.uriResolver != null) {
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.getStylesheetLocation() != null && !this.customContentTypeSet) {
            super.setContentType("text/html;charset=ISO-8859-1");
        }
        try {
            this.getTemplates();
        }
        catch (TransformerConfigurationException ex) {
            throw new ApplicationContextException("Cannot load stylesheet for XSLT view '" + this.getBeanName() + "'", ex);
        }
    }

    protected TransformerFactory newTransformerFactory(Class transformerFactoryClass) {
        if (transformerFactoryClass != null) {
            try {
                return (TransformerFactory)transformerFactoryClass.newInstance();
            }
            catch (Exception ex) {
                throw new TransformerFactoryConfigurationError(ex, "Could not instantiate TransformerFactory");
            }
        }
        return TransformerFactory.newInstance();
    }

    protected final TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        Source source = null;
        String docRoot = null;
        Object singleModel = null;
        if (this.useSingleModelNameAsRoot && model.size() == 1) {
            docRoot = (String)model.keySet().iterator().next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Single model object received, key [" + docRoot + "] will be used as root tag");
            }
            singleModel = model.get(docRoot);
        }
        if (singleModel instanceof Node || singleModel instanceof Source) {
            this.logger.debug("No need to domify: was passed an XML Node or Source");
            source = singleModel instanceof Node ? new DOMSource(singleModel) : (Source)singleModel;
        } else {
            source = this.createXsltSource(model, docRoot != null ? docRoot : this.root, request, response);
        }
        this.doTransform(model, source, request, response);
    }

    protected Source createXsltSource(Map model, String root, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    protected void doTransform(Map model, Source source, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map parameters = this.getParameters(model, request);
        StreamResult result = this.useWriter() ? new StreamResult(response.getWriter()) : new StreamResult(new BufferedOutputStream(response.getOutputStream()));
        String encoding = response.getCharacterEncoding();
        this.doTransform(source, parameters, result, encoding);
    }

    protected Map getParameters(Map model, HttpServletRequest request) {
        return this.getParameters(request);
    }

    protected Map getParameters(HttpServletRequest request) {
        return this.getParameters();
    }

    protected Map getParameters() {
        return null;
    }

    protected boolean useWriter() {
        return false;
    }

    protected void doTransform(Source source, Map parameters, Result result, String encoding) throws Exception {
        try {
            Transformer trans = this.buildTransformer(parameters);
            if (this.uriResolver != null) {
                trans.setURIResolver(this.uriResolver);
            }
            trans.setOutputProperty("encoding", encoding);
            if (this.indent) {
                TransformerUtils.enableIndenting(trans);
            }
            if (this.outputProperties != null) {
                Enumeration<?> propsEnum = this.outputProperties.propertyNames();
                while (propsEnum.hasMoreElements()) {
                    String propName = (String)propsEnum.nextElement();
                    trans.setOutputProperty(propName, this.outputProperties.getProperty(propName));
                }
            }
            trans.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            throw new NestedServletException("Couldn't create XSLT transformer in XSLT view with name [" + this.getBeanName() + "]", ex);
        }
        catch (TransformerException ex) {
            throw new NestedServletException("Couldn't perform transform in XSLT view with name [" + this.getBeanName() + "]", ex);
        }
    }

    protected Transformer buildTransformer(Map parameters) throws TransformerConfigurationException {
        Templates templates = this.getTemplates();
        Transformer transformer = templates != null ? templates.newTransformer() : this.getTransformerFactory().newTransformer();
        this.applyTransformerParameters(parameters, transformer);
        return transformer;
    }

    protected Templates getTemplates() throws TransformerConfigurationException {
        if (this.cachedTemplates != null) {
            return this.cachedTemplates;
        }
        Resource location = this.getStylesheetLocation();
        if (location != null) {
            Templates templates = this.getTransformerFactory().newTemplates(this.getStylesheetSource(location));
            if (this.cache) {
                this.cachedTemplates = templates;
            }
            return templates;
        }
        return null;
    }

    protected void applyTransformerParameters(Map parameters, Transformer transformer) {
        if (parameters != null) {
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                transformer.setParameter(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    protected Source getStylesheetSource(Resource stylesheetLocation) throws ApplicationContextException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading XSLT stylesheet from " + stylesheetLocation);
        }
        try {
            URL url = stylesheetLocation.getURL();
            String urlPath = url.toString();
            String systemId = urlPath.substring(0, urlPath.lastIndexOf(47) + 1);
            return new StreamSource(url.openStream(), systemId);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from " + stylesheetLocation, ex);
        }
    }
}

