/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.FileTypeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MockServletContext
implements ServletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final String resourceBasePath;
    private String contextPath = "";
    private final Map contexts = new HashMap();
    private final Properties initParameters = new Properties();
    private final Hashtable attributes = new Hashtable();
    private String servletContextName = "MockServletContext";

    public MockServletContext() {
        this("", null);
    }

    public MockServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockServletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath != null ? contextPath : "";
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void registerContext(String contextPath, ServletContext context) {
        this.contexts.put(contextPath, context);
    }

    public ServletContext getContext(String contextPath) {
        if (this.contextPath.equals(contextPath)) {
            return this;
        }
        return (ServletContext)this.contexts.get(contextPath);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String filePath) {
        return MimeTypeResolver.getMimeType(filePath);
    }

    public Set getResourcePaths(String path) {
        String actualPath = path.endsWith("/") ? path : path + "/";
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(actualPath));
        try {
            File file = resource.getFile();
            Object[] fileList = file.list();
            if (ObjectUtils.isEmpty(fileList)) {
                return null;
            }
            LinkedHashSet<String> resourcePaths = new LinkedHashSet<String>(fileList.length);
            for (int i = 0; i < fileList.length; ++i) {
                String resultPath = actualPath + (String)fileList[i];
                if (resource.createRelative((String)fileList[i]).getFile().isDirectory()) {
                    resultPath = resultPath + "/";
                }
                resourcePaths.add(resultPath);
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't get resource paths for " + resource, ex);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getURL();
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't get URL for " + resource, ex);
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't open InputStream for " + resource, ex);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public void log(Exception ex, String message) {
        this.logger.info(message, ex);
    }

    public void log(String message, Throwable ex) {
        this.logger.info(message, ex);
    }

    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't determine real path of resource " + resource, ex);
            return null;
        }
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        Assert.notNull(name, "Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    private static class MimeTypeResolver {
        private MimeTypeResolver() {
        }

        public static String getMimeType(String filePath) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(filePath);
        }
    }
}

