/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.Assert;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockRequestDispatcher(String url) {
        Assert.notNull(url, "URL must not be null");
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: forwarding to URL [" + this.url + "]");
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        this.getMockHttpServletResponse(response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: including URL [" + this.url + "]");
        }
    }

    protected MockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

