/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class HeaderValueHolder {
    private final List values = new LinkedList();

    HeaderValueHolder() {
    }

    public void setValue(Object value) {
        this.values.clear();
        this.values.add(value);
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void addValues(Collection values) {
        this.values.addAll(values);
    }

    public void addValueArray(Object values) {
        CollectionUtils.mergeArrayIntoCollection(values, this.values);
    }

    public List getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    public static HeaderValueHolder getByName(Map headers, String name) {
        Assert.notNull(name, "Header name must not be null");
        Iterator it = headers.keySet().iterator();
        while (it.hasNext()) {
            String headerName = (String)it.next();
            if (!headerName.equalsIgnoreCase(name)) continue;
            return (HeaderValueHolder)headers.get(headerName);
        }
        return null;
    }
}

