/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.springframework.aop.target.AbstractBeanFactoryBasedTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractPrototypeBasedTargetSource
extends AbstractBeanFactoryBasedTargetSource {
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (!beanFactory.isPrototype(this.getTargetBeanName())) {
            throw new BeanDefinitionStoreException("Cannot use prototype-based TargetSource against non-prototype bean with name '" + this.getTargetBeanName() + "': instances would not be independent");
        }
    }

    protected Object newPrototypeInstance() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating new instance of bean '" + this.getTargetBeanName() + "'");
        }
        return this.getBeanFactory().getBean(this.getTargetBeanName());
    }

    protected void destroyPrototypeInstance(Object target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying instance of bean '" + this.getTargetBeanName() + "'");
        }
        if (this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).destroyBean(this.getTargetBeanName(), target);
        } else if (target instanceof DisposableBean) {
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Throwable ex) {
                this.logger.error("Couldn't invoke destroy method of bean with name '" + this.getTargetBeanName() + "'", ex);
            }
        }
    }
}

