/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.AbstractMemoryHttpData;
import org.jboss.netty.handler.codec.http.Attribute;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.jboss.netty.handler.codec.http.InterfaceHttpData;

public class MemoryAttribute
extends AbstractMemoryHttpData
implements Attribute {
    public MemoryAttribute(String name) {
        super(name, HttpCodecUtil.DEFAULT_CHARSET, 0L);
    }

    public MemoryAttribute(String name, String value) throws NullPointerException, IllegalArgumentException, IOException {
        super(name, HttpCodecUtil.DEFAULT_CHARSET, 0L);
        this.setValue(value);
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        return this.getChannelBuffer().toString(this.charset);
    }

    @Override
    public void setValue(String value) throws IOException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        byte[] bytes = value.getBytes(this.charset);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(bytes);
        if (this.definedSize > 0L) {
            this.definedSize = buffer.readableBytes();
        }
        this.setContent(buffer);
    }

    @Override
    public void addContent(ChannelBuffer buffer, boolean last) throws IOException {
        int localsize = buffer.readableBytes();
        if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
            this.definedSize = this.size + (long)localsize;
        }
        super.addContent(buffer, last);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData arg0) {
        if (!(arg0 instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)arg0.getHttpDataType()));
        }
        return this.compareTo((Attribute)arg0);
    }

    @Override
    public int compareTo(Attribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.getValue();
    }
}

