/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.stat;

import com.xunlei.util.DateStringUtil;
import com.xunlei.util.HumanReadableUtil;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;

public class SystemInfo {
    private static String serverStartupTime;

    public static String getServerStartupTime() {
        if (serverStartupTime == null) {
            serverStartupTime = DateStringUtil.DEFAULT.format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime()));
        }
        return serverStartupTime;
    }

    private static String formatMemoryUsage(MemoryUsage mem) {
        String fmt = "\u521d\u59cb\u5316:%-10s \u5df2\u4f7f\u7528:%-10s \u6700\u5927:%-10s";
        return String.format(fmt, HumanReadableUtil.byteSize(mem.getInit()), HumanReadableUtil.byteSize(mem.getUsed()), HumanReadableUtil.byteSize(mem.getMax()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThreadsDetailInfo(int maxFrames) {
        ThreadInfo info;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = null;
        ThreadMXBean threadMXBean2 = threadMXBean;
        synchronized (threadMXBean2) {
            infos = threadMXBean.dumpAllThreads(true, true);
        }
        StringBuilder tmp = new StringBuilder();
        String fmt = "%-8s%-14s%-8s%-8s%s\n";
        tmp.append(String.format(fmt, "ID", "STATE ", "Blocks", "Waits", "Name"));
        int i = 0;
        while (i < infos.length) {
            info = infos[i];
            tmp.append(String.format(fmt, new Object[]{info.getThreadId(), info.getThreadState(), info.getBlockedCount(), info.getWaitedCount(), info.getThreadName()}));
            ++i;
        }
        tmp.append("\n");
        tmp.append("\n");
        i = 0;
        while (i < infos.length) {
            tmp.append("--------------- (");
            tmp.append(i);
            tmp.append(") ------------------------------------------------------------------------------------------------------------------------\n");
            info = infos[i];
            tmp.append(SystemInfo.printThreadInfo(info, maxFrames));
            ++i;
        }
        return tmp.toString();
    }

    public static String printThreadInfo(ThreadInfo info, int maxFrames) {
        LockInfo[] locks;
        int n;
        int n2;
        LockInfo[] lockInfoArray;
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\"" + " Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        int i = 0;
        StackTraceElement[] stackTrace = info.getStackTrace();
        while (i < stackTrace.length && i < maxFrames) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                    }
                }
            }
            lockInfoArray = info.getLockedMonitors();
            n2 = lockInfoArray.length;
            n = 0;
            while (n < n2) {
                LockInfo mi = lockInfoArray[n];
                if (((MonitorInfo)mi).getLockedStackDepth() == i) {
                    sb.append("\t-  locked " + mi);
                    sb.append('\n');
                }
                ++n;
            }
            ++i;
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = info.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            lockInfoArray = locks;
            n2 = locks.length;
            n = 0;
            while (n < n2) {
                LockInfo li = lockInfoArray[n];
                sb.append("\t- " + li);
                sb.append('\n');
                ++n;
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String getSytemInfo() {
        StringBuilder tmp = new StringBuilder();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        tmp.append("runtimeMXBean\n");
        tmp.append("\u542f\u52a8\u65f6\u95f4:\t\t").append(SystemInfo.getServerStartupTime()).append("\n");
        tmp.append("\u5df2\u8fd0\u884c:\t\t\t").append(HumanReadableUtil.timeSpan(runtimeMXBean.getUptime())).append("\n");
        tmp.append("\u540d\u79f0:\t\t\t").append(runtimeMXBean.getName()).append("\n");
        tmp.append("\u865a\u62df\u673a:\t\t\t").append(runtimeMXBean.getVmName()).append(" ").append(runtimeMXBean.getVmVersion()).append("\n");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        tmp.append("\n");
        tmp.append("ThreadMXBean\n");
        tmp.append("\u5f53\u524d\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getThreadCount()).append("\n");
        tmp.append("\u540e\u53f0\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getDaemonThreadCount()).append("\n");
        tmp.append("\u5cf0\u503c\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getPeakThreadCount()).append("\n");
        tmp.append("\u5df2\u542f\u52a8\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getTotalStartedThreadCount()).append("\n");
        tmp.append("\n");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        tmp.append("memoryMXBean\n");
        tmp.append("\u5df2\u4f7f\u7528\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).append("\n");
        tmp.append("\u5df2\u5206\u914d\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().totalMemory())).append("\n");
        tmp.append("\u6700\u5927\u5185\u5b58:\t\t").append(HumanReadableUtil.byteSize(Runtime.getRuntime().maxMemory())).append("\n");
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        tmp.append("\u5806\u5185\u5b58:\t\t\t").append(SystemInfo.formatMemoryUsage(memoryMXBean.getHeapMemoryUsage())).append("\n");
        tmp.append("\u975e\u5806\u5185\u5b58:\t\t").append(SystemInfo.formatMemoryUsage(memoryMXBean.getNonHeapMemoryUsage())).append("\n");
        tmp.append("\u5f85\u56de\u6536\u5bf9\u8c61\u6570:\t\t").append(memoryMXBean.getObjectPendingFinalizationCount()).append("\n");
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        tmp.append("\n");
        tmp.append("operatingSystemMXBean\n");
        tmp.append("\u64cd\u4f5c\u7cfb\u7edf:\t\t").append(operatingSystemMXBean.getName()).append(" ").append(operatingSystemMXBean.getVersion()).append("\n");
        tmp.append("\u4f53\u7cfb\u7ed3\u6784:\t\t").append(operatingSystemMXBean.getArch()).append("\n");
        tmp.append("\u5904\u7406\u5668\u4e2a\u6570:\t\t").append(operatingSystemMXBean.getAvailableProcessors()).append("\n");
        tmp.append("\u7cfb\u7edf\u8d1f\u8f7d:\t\t").append(operatingSystemMXBean.getSystemLoadAverage()).append("\n");
        return tmp.toString();
    }
}

