/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.concurrent;

import com.xunlei.util.HumanReadableUtil;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Bench {
    public static int DEFAULT_WARMUPS = 1000;
    private boolean debug = true;
    private DecimalFormat integerFormat = new DecimalFormat("#,##0.000");
    private ExecutorService mainExecutor;
    private int measurements;
    private int threads;
    private ExecutorService warmUpExecutor;
    private int warmupMeasurements = DEFAULT_WARMUPS;
    private int timesPerMeasurements;

    public static long memoryUsed() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static void restoreJvm0() {
        final CountDownLatch drained = new CountDownLatch(1);
        try {
            System.gc();
            new Object(){

                protected void finalize() {
                    drained.countDown();
                }
            };
            System.gc();
            drained.await();
            System.gc();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    public static void restoreJvm() {
        int maxRestoreJvmLoops = 10;
        long memUsedPrev = Bench.memoryUsed();
        int i = 0;
        while (i < maxRestoreJvmLoops) {
            System.runFinalization();
            System.gc();
            long memUsedNow = Bench.memoryUsed();
            if (ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount() == 0 && memUsedNow >= memUsedPrev) break;
            memUsedPrev = memUsedNow;
            ++i;
        }
    }

    public Bench(int threads, int measurements, int warmupMeasurements, int timesPerMeasurements) {
        this.threads = threads <= 0 ? 1 : threads;
        this.measurements = measurements <= 0 ? 1 : measurements;
        this.warmupMeasurements = warmupMeasurements <= 0 ? DEFAULT_WARMUPS : warmupMeasurements;
        this.timesPerMeasurements = timesPerMeasurements <= 0 ? 1 : timesPerMeasurements;
        this.warmUpExecutor = Executors.newSingleThreadExecutor();
        this.mainExecutor = Executors.newFixedThreadPool(this.threads);
    }

    private void _run(Runnable task, ExecutorService executor, int times) {
        if (executor == null || task == null) {
            return;
        }
        TimeMeasureProxy timeMeasureProxy = new TimeMeasureProxy(task, times);
        int i = 0;
        while (i < times) {
            executor.execute(timeMeasureProxy);
            ++i;
        }
        timeMeasureProxy.await();
    }

    private void doMeasure(String label, Runnable task) {
        Bench.restoreJvm();
        long startTime = System.nanoTime();
        this._run(task, this.mainExecutor, this.measurements);
        this.printResult(label, startTime);
    }

    private void doWarmup(Runnable task) {
        Bench.restoreJvm();
        long startTime = System.nanoTime();
        this._run(task, this.warmUpExecutor, this.warmupMeasurements);
    }

    public void measure(String label, Runnable task) {
        if (this.debug) {
            System.out.println("\tSTARTUP WARMUP  " + label);
        }
        this.doWarmup(task);
        if (this.debug) {
            System.out.println("\tSTARTUP MEASURE " + label);
        }
        this.doMeasure(label, task);
    }

    private void printResult(String label, long startTime) {
        long span = System.nanoTime() - startTime;
        double avg = (double)(span / (long)this.measurements / (long)this.timesPerMeasurements) / 1000000.0;
        String avgStr = String.valueOf(this.integerFormat.format(avg)) + "ms";
        double total = (double)span / 1000000.0;
        String totalStr = String.valueOf(this.integerFormat.format(total)) + "ms";
        double tps = (double)(this.measurements * this.timesPerMeasurements) / ((double)span / 1.0E9);
        String tpsStr = this.integerFormat.format(tps);
        System.out.println(String.format("%-30s[avg:%-20s total:%-20s tps:%-20s mem:%-10s]", label, avgStr, totalStr, tpsStr, HumanReadableUtil.byteSize(Bench.memoryUsed())));
    }

    public void shutdown() {
        this.warmUpExecutor.shutdown();
        this.mainExecutor.shutdown();
    }

    public String toString() {
        return "Bench [threads=" + this.threads + ", measurements=" + this.measurements + ", warmupMeasurements=" + this.warmupMeasurements + ", timesPerMeasurements=" + this.timesPerMeasurements + "]";
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private class TimeMeasureProxy
    implements Runnable {
        private CountDownLatch measureLatch;
        private Runnable runnable;

        public TimeMeasureProxy(Runnable runnable, int measurements) {
            this.runnable = runnable;
            this.measureLatch = new CountDownLatch(measurements);
        }

        public void await() {
            try {
                this.measureLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            this.runnable.run();
            this.measureLatch.countDown();
        }
    }
}

