/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class CloseableHelper {
    private static final Map<Class<?>, Method> closeMethodCache = new HashMap(2);
    private static final Logger log = Log.getLogger();

    public static void close(Closeable c) throws IOException {
        if (c != null) {
            c.close();
        }
    }

    public static void close(Object c) throws Exception {
        if (c != null) {
            Class<?> clazz = c.getClass();
            Method cachedMehtod = closeMethodCache.get(clazz);
            if (cachedMehtod == null) {
                Method m = clazz.getMethod("close", new Class[0]);
                m.invoke(c, new Object[0]);
                closeMethodCache.put(clazz, m);
            } else {
                cachedMehtod.invoke(c, new Object[0]);
            }
        }
    }

    public static void close(Socket c) throws IOException {
        if (c != null) {
            c.close();
        }
    }

    public static void closeSilently(Closeable c) {
        try {
            CloseableHelper.close(c);
        }
        catch (IOException e) {
            log.info("", e);
        }
    }

    public static void closeSilently(Object c) {
        try {
            CloseableHelper.close(c);
        }
        catch (Exception e) {
            log.info("", e);
        }
    }

    public static void closeSilently(Socket c) {
        try {
            CloseableHelper.close(c);
        }
        catch (IOException e) {
            log.info("", e);
        }
    }

    private CloseableHelper() {
    }
}

