/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.spring;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class BeanUtil {
    private static final Set<Type> basicTypes = new HashSet<Type>();

    static {
        basicTypes.add(Integer.TYPE);
        basicTypes.add((Type)((Object)Integer.class));
        basicTypes.add(Long.TYPE);
        basicTypes.add((Type)((Object)Long.class));
        basicTypes.add(Float.TYPE);
        basicTypes.add((Type)((Object)Float.class));
        basicTypes.add(Double.TYPE);
        basicTypes.add((Type)((Object)Double.class));
        basicTypes.add(Short.TYPE);
        basicTypes.add((Type)((Object)Short.class));
        basicTypes.add(Boolean.TYPE);
        basicTypes.add((Type)((Object)Boolean.class));
        basicTypes.add(Character.TYPE);
        basicTypes.add((Type)((Object)Character.class));
        basicTypes.add(Byte.TYPE);
        basicTypes.add((Type)((Object)Byte.class));
        basicTypes.add((Type)((Object)String.class));
    }

    public static <T> T getTypedBean(ApplicationContext context, String name) throws BeansException {
        return (T)context.getBean(name);
    }

    public static <T> T getTypedBean(ApplicationContext context, Class<T> clazz) throws BeansException {
        String oriName = clazz.getSimpleName();
        String name = String.valueOf(oriName.substring(0, 1).toLowerCase()) + oriName.substring(1);
        return (T)context.getBean(name);
    }

    public static boolean isBasicType(Type clazz) {
        return basicTypes.contains(clazz);
    }

    public static boolean isNotBasicType(Type clazz) {
        return !BeanUtil.isBasicType(clazz);
    }
}

