/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.client;

import com.xunlei.server.common.util.CommonUtil;
import com.xunlei.server.common.util.MD5Util;
import com.xunlei.server.register.proxy.GameUserException;
import com.xunlei.server.register.proxy.XLUsrInfo;
import com.xunlei.server.register.proxy.result.AuthenticateResult;
import com.xunlei.server.register.proxy.result.UserExistsResult;
import com.xunlei.server.register.usrproxy.ProxyUtil;
import com.xunlei.server.usercentre.util.ConstantsCmd;
import com.xunlei.server.usercentre.util.ConstantsRetCode;
import com.xunlei.server.usercentre.util.SocketUtil;
import com.xunlei.server.usercentre.util.StringTools;
import com.xunlei.server.usercentre.util.Utils;
import com.xunlei.server.usercentre.util.Validator;
import com.xunlei.server.usercentre.vo.GameUserInfo;
import com.xunlei.server.usercentre.vo.SimpleUserInfo;
import com.xunlei.server.usercentre.vo.UserInfoDetail;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class GameUserCentreClient {
    private int timeout;
    private String socketAddress;
    private int port;
    private Random random;
    private static final String charset = "gbk";
    private Logger logger = Logger.getLogger(this.getClass());
    private String socketAddress1;
    private String socketAddress2;
    private ScheduledExecutorService scheduledExecutor;

    private void init(final String user) {
        if (this.socketAddress2 != null) {
            this.detect(user);
            this.scheduledExecutor = Executors.newScheduledThreadPool(3);
            this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    GameUserCentreClient.this.detect(user);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public void destroyExecutor() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    public SimpleUserInfo getSimpleUserInfo(String username, int getflag) throws GameUserException {
        SimpleUserInfo simpleUserInfo;
        byte[] readData;
        Socket socket;
        SimpleUserInfo userinfo;
        block8: {
            int readLength;
            InputStream input;
            byte[] sn;
            block7: {
                userinfo = new SimpleUserInfo();
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[36];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.QUERY_SIMPLEUSERINFO_CMD, 0, data, 2, 10);
                username = CommonUtil.formatString(username, 20, ' ', true);
                System.arraycopy(username.getBytes(), 0, data, 12, 20);
                System.arraycopy(Utils.getBytes4FromInt(getflag), 0, data, 32, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block7;
                this.logger.error("Invalid package length: " + readLength);
                userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
                SimpleUserInfo simpleUserInfo2 = userinfo;
                SocketUtil.release(socket);
                return simpleUserInfo2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block8;
            this.logger.error("Invalid sn. ");
            userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
            SimpleUserInfo simpleUserInfo3 = userinfo;
            SocketUtil.release(socket);
            return simpleUserInfo3;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int code = Integer.parseInt(retCode);
            userinfo.setRetcode(code);
            if (code == ConstantsRetCode.RETCODE_SUCCESS) {
                byte[] oldAccountBytes = new byte[20];
                System.arraycopy(readData, 6, oldAccountBytes, 0, 20);
                userinfo.setOldusername(new String(oldAccountBytes).trim());
                byte[] newAccountBytes = new byte[20];
                System.arraycopy(readData, 26, newAccountBytes, 0, 20);
                userinfo.setDigitno(new String(newAccountBytes).trim());
                byte[] xlinneridBytes = new byte[20];
                System.arraycopy(readData, 46, xlinneridBytes, 0, 20);
                userinfo.setXlinnerid(new String(xlinneridBytes).trim());
                byte[] emailBytes = new byte[50];
                System.arraycopy(readData, 66, emailBytes, 0, 50);
                userinfo.setBindemail(new String(emailBytes).trim());
                byte[] idcardBytes = new byte[18];
                System.arraycopy(readData, 116, idcardBytes, 0, 18);
                userinfo.setIdcardno(new String(idcardBytes).trim());
                byte[] gameuseridBytes = new byte[20];
                System.arraycopy(readData, 134, gameuseridBytes, 0, 16);
                userinfo.setGameuserid(new String(gameuseridBytes).trim());
                byte[] nicknameBytes = new byte[20];
                System.arraycopy(readData, 150, nicknameBytes, 0, 20);
                String nickname = new String(nicknameBytes);
                userinfo.setNickname(nickname.trim());
            }
            simpleUserInfo = userinfo;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return simpleUserInfo;
    }

    public UserInfoDetail getUserInfoDetail(String username, int getflag) throws GameUserException {
        UserInfoDetail userInfoDetail;
        byte[] readData;
        Socket socket;
        UserInfoDetail userinfo;
        block8: {
            int readLength;
            InputStream input;
            byte[] sn;
            block7: {
                userinfo = new UserInfoDetail();
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[36];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.QUERY_USERINFODETAIL_CMD, 0, data, 2, 10);
                username = CommonUtil.formatString(username, 20, ' ', true);
                System.arraycopy(username.getBytes(), 0, data, 12, 20);
                System.arraycopy(Utils.getBytes4FromInt(getflag), 0, data, 32, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block7;
                this.logger.error("Invalid package length: " + readLength);
                userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
                UserInfoDetail userInfoDetail2 = userinfo;
                SocketUtil.release(socket);
                return userInfoDetail2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block8;
            this.logger.error("Invalid sn. ");
            userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
            UserInfoDetail userInfoDetail3 = userinfo;
            SocketUtil.release(socket);
            return userInfoDetail3;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int code = Integer.parseInt(retCode);
            userinfo.setRetcode(code);
            if (code == ConstantsRetCode.RETCODE_SUCCESS) {
                userinfo.setUserInfo(new String(readData, charset).substring(22));
            }
            userInfoDetail = userinfo;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return userInfoDetail;
    }

    public GameUserInfo getGameUserInfo(String username, int usertype) throws GameUserException {
        GameUserInfo gameUserInfo;
        byte[] readData;
        int readLength;
        Socket socket;
        GameUserInfo userinfo;
        block9: {
            InputStream input;
            byte[] sn;
            block8: {
                userinfo = new GameUserInfo();
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[36];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.QUERY_GAMEUSERINFO_CMD, 0, data, 2, 10);
                username = CommonUtil.formatString(username, 20, ' ', true);
                System.arraycopy(username.getBytes(), 0, data, 12, 20);
                System.arraycopy(Utils.getBytes4FromInt(usertype), 0, data, 32, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block8;
                this.logger.error("Invalid package length: " + readLength);
                userinfo.setSeqid(-254L);
                GameUserInfo gameUserInfo2 = userinfo;
                SocketUtil.release(socket);
                return gameUserInfo2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block9;
            this.logger.error("Invalid sn. ");
            userinfo.setSeqid(-254L);
            GameUserInfo gameUserInfo3 = userinfo;
            SocketUtil.release(socket);
            return gameUserInfo3;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int code = Integer.parseInt(retCode);
            if (code == 1) {
                userinfo.setGameUserInfo(new String(readData, 6, readLength - 6, "GBK"));
            } else {
                userinfo.setSeqid(code * -1);
            }
            gameUserInfo = userinfo;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return gameUserInfo;
    }

    public UserInfoDetail getUserInfoDetail60(String username, int getflag) throws GameUserException {
        UserInfoDetail userInfoDetail;
        byte[] readData;
        Socket socket;
        UserInfoDetail userinfo;
        block8: {
            int readLength;
            InputStream input;
            byte[] sn;
            block7: {
                userinfo = new UserInfoDetail();
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[76];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.QUERY_USERINFODETAIL60_CMD, 0, data, 2, 10);
                username = CommonUtil.formatString(username, 60, ' ', true);
                System.arraycopy(username.getBytes(), 0, data, 12, 60);
                System.arraycopy(Utils.getBytes4FromInt(getflag), 0, data, 72, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block7;
                this.logger.error("Invalid package length: " + readLength);
                userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
                UserInfoDetail userInfoDetail2 = userinfo;
                SocketUtil.release(socket);
                return userInfoDetail2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block8;
            this.logger.error("Invalid sn. ");
            userinfo.setRetcode(ConstantsRetCode.RETCODE_PARAM_ERROR);
            UserInfoDetail userInfoDetail3 = userinfo;
            SocketUtil.release(socket);
            return userInfoDetail3;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            int code = Integer.parseInt(retCode);
            userinfo.setRetcode(code);
            if (code == ConstantsRetCode.RETCODE_SUCCESS) {
                userinfo.setUserInfo(new String(readData, charset).substring(22));
            }
            userInfoDetail = userinfo;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return userInfoDetail;
    }

    public int queryUserVipInfo(String user, int getflag) throws GameUserException {
        int n;
        byte[] readData;
        Socket socket;
        block7: {
            int readLength;
            InputStream input;
            byte[] sn;
            block6: {
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[33];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.QUERY_USERVIP_CMD, 0, data, 2, 10);
                user = CommonUtil.formatString(user, 20, ' ', true);
                System.arraycopy(user.getBytes(), 0, data, 12, 20);
                System.arraycopy(String.valueOf(getflag).getBytes(), 0, data, 32, 1);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block6;
                this.logger.error("Invalid package length: " + readLength);
                int n2 = 2;
                SocketUtil.release(socket);
                return n2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block7;
            this.logger.error("Invalid sn. ");
            int n3 = 2;
            SocketUtil.release(socket);
            return n3;
        }
        try {
            int code;
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            n = code = Integer.parseInt(retCode);
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return n;
    }

    private void detect(String user) {
        boolean mainOk = false;
        for (int i = 0; i < 3; ++i) {
            try {
                this.userExists(user, this.socketAddress1);
                mainOk = true;
                break;
            }
            catch (Exception e) {
                if (i != 2) continue;
                e.printStackTrace();
                continue;
            }
        }
        this.socketAddress = mainOk ? this.socketAddress1 : this.socketAddress2;
    }

    public void setSocketAddress2(String socketAddress2) {
        this.socketAddress2 = socketAddress2;
    }

    public UserExistsResult userExists(String username) throws GameUserException {
        return this.userExists(username, this.socketAddress);
    }

    private UserExistsResult userExists(String username, String socketAddress) throws GameUserException {
        UserExistsResult userExistsResult;
        byte[] readData;
        Socket socket;
        UserExistsResult userExistsResult2;
        block8: {
            int readLength;
            InputStream input;
            byte[] sn;
            block7: {
                userExistsResult2 = new UserExistsResult();
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[32];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.USER_EXIST_CMD, 0, data, 2, 10);
                username = CommonUtil.formatString(username, 20, ' ', true);
                System.arraycopy(username.getBytes(), 0, data, 12, 20);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block7;
                this.logger.error("Invalid package length: " + readLength);
                userExistsResult2.setCode(9999);
                UserExistsResult userExistsResult3 = userExistsResult2;
                SocketUtil.release(socket);
                return userExistsResult3;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block8;
            this.logger.error("Invalid sn. ");
            userExistsResult2.setCode(9999);
            UserExistsResult userExistsResult4 = userExistsResult2;
            SocketUtil.release(socket);
            return userExistsResult4;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            userExistsResult2.setCode(code);
            if (code == 0) {
                userExistsResult2.setCode(0);
                byte[] accountTypeBytes = new byte[1];
                System.arraycopy(readData, 6, accountTypeBytes, 0, 1);
                byte accountType = Byte.parseByte(new String(accountTypeBytes));
                userExistsResult2.setAccountType(accountType);
                byte[] userIdBytes = new byte[16];
                System.arraycopy(readData, 7, userIdBytes, 0, 16);
                String userId = new String(userIdBytes);
                userExistsResult2.setUserId(userId.trim());
                byte[] newAccountBytes = new byte[20];
                System.arraycopy(readData, 23, newAccountBytes, 0, 20);
                String newAccount = new String(newAccountBytes);
                userExistsResult2.setNewAccount(newAccount.trim());
                byte[] oldAccountBytes = new byte[20];
                System.arraycopy(readData, 43, oldAccountBytes, 0, 20);
                String oldAccount = new String(oldAccountBytes);
                userExistsResult2.setOldAccount(oldAccount.trim());
            }
            userExistsResult = userExistsResult2;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return userExistsResult;
    }

    public GameUserCentreClient(String socketAddress, int port, int timeout) {
        this(socketAddress, port, timeout, null);
    }

    public GameUserCentreClient(String socketAddress, int port, int timeout, String socketAddress2) {
        this.timeout = timeout;
        this.random = new Random();
        this.socketAddress = socketAddress;
        this.port = port;
        this.socketAddress1 = socketAddress;
        this.socketAddress2 = socketAddress2;
        this.init("fengtong");
    }

    public AuthenticateResult userLogin(String account, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        AuthenticateResult authenticateResult;
        byte[] readData;
        Socket socket;
        UserInfoDetail xlinfo;
        AuthenticateResult authenticateResult2;
        block16: {
            int readLength;
            InputStream input;
            byte[] sn;
            block15: {
                authenticateResult2 = new AuthenticateResult();
                if (sourceId == null) {
                    sourceId = "";
                }
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[76];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.USER_LOGIN_CMD, 0, data, 2, 10);
                xlinfo = null;
                if (Validator.isEmail(account)) {
                    xlinfo = this.getUserInfoDetail60(account, 4);
                    if (null != xlinfo) {
                        account = StringTools.isNotEmpty(((XLUsrInfo)xlinfo).getUsername()) ? ((XLUsrInfo)xlinfo).getUsername() : ((XLUsrInfo)xlinfo).getUsernewno();
                    } else {
                        authenticateResult2.setCode(1);
                        return authenticateResult2;
                    }
                }
                account = CommonUtil.formatString(account, 20, ' ', true);
                password = CommonUtil.formatString(password, 20, ' ', true);
                sourceId = CommonUtil.formatString(sourceId, 20, ' ', true);
                System.arraycopy(account.getBytes(), 0, data, 12, 20);
                System.arraycopy(password.getBytes(), 0, data, 32, 20);
                System.arraycopy(sourceId.getBytes(), 0, data, 52, 20);
                String t = String.valueOf(invokeBy);
                String utype = "0000".substring(t.length()) + t;
                System.arraycopy(utype.getBytes(), 0, data, 72, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block15;
                this.logger.error("Invalid package length: " + readLength);
                authenticateResult2.setCode(5);
                AuthenticateResult authenticateResult3 = authenticateResult2;
                SocketUtil.release(socket);
                return authenticateResult3;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block16;
            this.logger.error("Invalid sn. ");
            authenticateResult2.setCode(5);
            AuthenticateResult authenticateResult4 = authenticateResult2;
            SocketUtil.release(socket);
            return authenticateResult4;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            authenticateResult2.setCode(code);
            if (code == 8 || code == 0) {
                byte[] accountTypeBytes = new byte[1];
                System.arraycopy(readData, 6, accountTypeBytes, 0, 1);
                byte accountType = Byte.parseByte(new String(accountTypeBytes));
                authenticateResult2.setAccountType(accountType);
                byte[] userIdBytes = new byte[16];
                System.arraycopy(readData, 7, userIdBytes, 0, 16);
                String userId = new String(userIdBytes);
                authenticateResult2.setUserId(userId.trim());
                byte[] newAccountBytes = new byte[20];
                System.arraycopy(readData, 23, newAccountBytes, 0, 20);
                String newAccount = new String(newAccountBytes);
                authenticateResult2.setNewAccount(newAccount.trim());
                byte[] oldAccountBytes = new byte[20];
                System.arraycopy(readData, 43, oldAccountBytes, 0, 20);
                String oldAccount = new String(oldAccountBytes);
                authenticateResult2.setOldAccount(oldAccount.trim());
            }
            if (checkAdult && code == 8) {
                if (xlinfo == null) {
                    xlinfo = StringTools.isNotEmpty(authenticateResult2.getNewAccount()) ? this.getUserInfoDetail(authenticateResult2.getNewAccount(), 1) : this.getUserInfoDetail(authenticateResult2.getOldAccount(), 0);
                }
                if (null != xlinfo && Validator.isAdultFromCardNo(((XLUsrInfo)xlinfo).getIdcardno())) {
                    code = 0;
                    authenticateResult2.setCode(0);
                }
            }
            if (!checkAdult && code == 8) {
                authenticateResult2.setCode(0);
            }
            authenticateResult = authenticateResult2;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return authenticateResult;
    }

    public AuthenticateResult authenticateUserRemote(String account, String password, String sourceId, boolean checkAdult, int invokeBy) throws GameUserException {
        AuthenticateResult authenticateResult;
        byte[] readData;
        Socket socket;
        AuthenticateResult authenticateResult2;
        block10: {
            int readLength;
            InputStream input;
            byte[] sn;
            block9: {
                authenticateResult2 = new AuthenticateResult();
                if (sourceId == null) {
                    sourceId = "";
                }
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[88];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.USER_LOGIN_REMOTE_CMD, 0, data, 2, 10);
                account = CommonUtil.formatString(account, 20, ' ', true);
                password = CommonUtil.formatString(password, 32, ' ', true);
                sourceId = CommonUtil.formatString(sourceId, 20, ' ', true);
                System.arraycopy(account.getBytes(), 0, data, 12, 20);
                System.arraycopy(password.getBytes(), 0, data, 32, 32);
                System.arraycopy(sourceId.getBytes(), 0, data, 64, 20);
                String t = String.valueOf(invokeBy);
                String utype = "0000".substring(t.length()) + t;
                System.arraycopy(utype.getBytes(), 0, data, 84, 4);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block9;
                this.logger.error("Invalid package length: " + readLength);
                authenticateResult2.setCode(5);
                AuthenticateResult authenticateResult3 = authenticateResult2;
                SocketUtil.release(socket);
                return authenticateResult3;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block10;
            this.logger.error("Invalid sn. ");
            authenticateResult2.setCode(5);
            AuthenticateResult authenticateResult4 = authenticateResult2;
            SocketUtil.release(socket);
            return authenticateResult4;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode);
            int code = Integer.parseInt(retCode);
            authenticateResult2.setCode(code);
            if (code == 8 || code == 0) {
                byte[] accountTypeBytes = new byte[1];
                System.arraycopy(readData, 6, accountTypeBytes, 0, 1);
                byte accountType = Byte.parseByte(new String(accountTypeBytes));
                authenticateResult2.setAccountType(accountType);
                byte[] userIdBytes = new byte[16];
                System.arraycopy(readData, 7, userIdBytes, 0, 16);
                String userId = new String(userIdBytes);
                authenticateResult2.setUserId(userId.trim());
                byte[] newAccountBytes = new byte[20];
                System.arraycopy(readData, 23, newAccountBytes, 0, 20);
                String newAccount = new String(newAccountBytes);
                authenticateResult2.setNewAccount(newAccount.trim());
                byte[] oldAccountBytes = new byte[20];
                System.arraycopy(readData, 43, oldAccountBytes, 0, 20);
                String oldAccount = new String(oldAccountBytes);
                authenticateResult2.setOldAccount(oldAccount.trim());
            }
            if (!checkAdult && code == 8) {
                authenticateResult2.setCode(0);
            }
            authenticateResult = authenticateResult2;
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return authenticateResult;
    }

    public int updateUserInfo(UserInfoDetail userinfo, int usertype) throws GameUserException {
        int n;
        byte[] readData;
        Socket socket;
        block15: {
            int readLength;
            InputStream input;
            byte[] sn;
            block14: {
                if (null == userinfo || StringTools.isEmpty(userinfo.getUsername()) && StringTools.isEmpty(userinfo.getUsernewno()) && StringTools.isEmpty(userinfo.getNo())) {
                    return ConstantsRetCode.RETCODE_PARAM_ERROR;
                }
                sn = new byte[2];
                this.random.nextBytes(sn);
                StringBuilder sb = new StringBuilder();
                if (StringTools.isNotEmpty(userinfo.getIdcardno())) {
                    sb.append("idcardno\t").append(userinfo.getIdcardno()).append("\n");
                }
                if (StringTools.isNotEmpty(userinfo.getTruename())) {
                    sb.append("truename\t").append(ProxyUtil.escapeForbidChar(userinfo.getTruename())).append("\n");
                }
                byte[] modifydata = sb.toString().getBytes();
                byte[] data = new byte[36 + modifydata.length];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.UPDATE_USERINFO_CMD, 0, data, 2, 10);
                String username = null;
                switch (usertype) {
                    case 1: {
                        username = CommonUtil.formatString(userinfo.getUsernewno(), 20, ' ', true);
                        break;
                    }
                    case 0: {
                        username = CommonUtil.formatString(userinfo.getUsername(), 20, ' ', true);
                        break;
                    }
                    case 2: {
                        username = CommonUtil.formatString(userinfo.getNo(), 20, ' ', true);
                        break;
                    }
                    default: {
                        return ConstantsRetCode.RETCODE_PARAM_ERROR;
                    }
                }
                System.arraycopy(username.getBytes(), 0, data, 12, 20);
                System.arraycopy(Utils.getBytes4FromInt(usertype), 0, data, 32, 4);
                System.arraycopy(modifydata, 0, data, 36, modifydata.length);
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0 && readLength <= 1024) break block14;
                this.logger.error("Invalid package length: " + readLength);
                int n2 = ConstantsRetCode.RETCODE_PARAM_ERROR;
                SocketUtil.release(socket);
                return n2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block15;
            this.logger.error("Invalid sn. ");
            int n3 = ConstantsRetCode.RETCODE_SYS_ERROR;
            SocketUtil.release(socket);
            return n3;
        }
        try {
            int code;
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            n = code = Integer.parseInt(new String(returnCode).trim());
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return n;
    }

    public int register(XLUsrInfo info) throws GameUserException {
        int n;
        byte[] readData;
        Socket socket;
        block18: {
            int readLength;
            InputStream input;
            byte[] sn;
            block17: {
                if (info == null || StringTools.isEmpty(info.getUsername()) || StringTools.isEmpty(info.getNick()) || StringTools.isEmpty(info.getPasswd())) {
                    return 404;
                }
                if (StringTools.isNotEmpty(info.getMail()) && !Validator.isEmail(info.getMail())) {
                    return 404;
                }
                info.setUsername(info.getUsername().trim());
                if (Validator.isNumber(info.getUsername()) || !Validator.isCharAndDigit(info.getUsername())) {
                    return 401;
                }
                if (info.getUsername().length() < 6 || info.getUsername().length() > 20) {
                    throw new GameUserException(info.getUsername() + " length less than 6 or bigger than 20.");
                }
                if (info.getQuestion() == null) {
                    info.setQuestion("");
                }
                if (info.getAnswer() == null) {
                    info.setAnswer("");
                }
                if (StringTools.isNotEmpty(info.getIdcardno())) {
                    UserInfoDetail old;
                    if (!Validator.isChinaIdCardNo(info.getIdcardno())) {
                        return 501;
                    }
                    if (!Validator.isAdultFromCardNo(info.getIdcardno()) && null != (old = this.getUserInfoDetail(info.getIdcardno(), 3)) && (StringTools.isNotEmpty(old.getUsername()) || StringTools.isNotEmpty(old.getUsernewno()))) {
                        return 502;
                    }
                }
                info.setUsername(ProxyUtil.escapeForbidChar(info.getUsername()));
                info.setNick(ProxyUtil.escapeForbidChar(info.getNick()));
                info.setMail(ProxyUtil.escapeForbidChar(info.getMail()));
                info.setQuestion(ProxyUtil.escapeForbidChar(info.getQuestion()));
                info.setAnswer(ProxyUtil.escapeForbidChar(info.getAnswer()));
                String password = info.getPasswd();
                password = CommonUtil.byteArrayToHexString(MD5Util.MD5Encode(password.getBytes())).toLowerCase();
                password = CommonUtil.byteArrayToHexString(MD5Util.MD5Encode(password.getBytes())).toLowerCase();
                info.setPasswd(password);
                info.setUsername(CommonUtil.formatString(info.getUsername(), 20, ' ', true));
                info.setNick(CommonUtil.formatString(info.getNick(), 20, ' ', true));
                info.setMail(CommonUtil.formatString(info.getMail(), 30, ' ', true));
                info.setQuestion(CommonUtil.formatString(info.getQuestion(), 50, ' ', true));
                info.setAnswer(CommonUtil.formatString(info.getAnswer(), 50, ' ', true));
                info.setTruename(CommonUtil.formatString(info.getTruename(), 30, ' ', true));
                info.setIdcardno(CommonUtil.formatString(info.getIdcardno(), 30, ' ', true));
                sn = new byte[2];
                this.random.nextBytes(sn);
                byte[] data = new byte[274];
                data[0] = sn[0];
                data[1] = sn[1];
                System.arraycopy(ConstantsCmd.USER_REGISTER_CMD, 0, data, 2, 10);
                try {
                    System.arraycopy(info.getUsername().getBytes(charset), 0, data, 12, 20);
                    System.arraycopy(info.getPasswd().getBytes(charset), 0, data, 32, 32);
                    System.arraycopy(info.getNick().getBytes(charset), 0, data, 64, 20);
                    System.arraycopy(info.getMail().getBytes(charset), 0, data, 84, 30);
                    System.arraycopy(info.getQuestion().getBytes(charset), 0, data, 114, 50);
                    System.arraycopy(info.getAnswer().getBytes(charset), 0, data, 164, 50);
                    System.arraycopy(info.getTruename().getBytes(charset), 0, data, 214, 30);
                    System.arraycopy(info.getIdcardno().getBytes(charset), 0, data, 244, 30);
                }
                catch (UnsupportedEncodingException e2) {
                    throw new GameUserException(e2);
                }
                byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
                socket = null;
                socket = new Socket(this.socketAddress, this.port);
                socket.setReuseAddress(true);
                socket.setSoLinger(false, 0);
                socket.setSoTimeout(this.timeout);
                input = socket.getInputStream();
                OutputStream output = socket.getOutputStream();
                output.write(lengthBytes);
                output.write(data);
                byte[] readLengthBytes = new byte[4];
                input.read(readLengthBytes);
                readLength = CommonUtil.byteArrayToInt(readLengthBytes);
                if (readLength > 0) break block17;
                this.logger.error("Invalid package length: " + readLength);
                int n2 = 500;
                SocketUtil.release(socket);
                return n2;
            }
            readData = new byte[readLength];
            input.read(readData);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] == sn[0] && readSn[1] == sn[1]) break block18;
            this.logger.error("Invalid sn. ");
            int n3 = 500;
            SocketUtil.release(socket);
            return n3;
        }
        try {
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            n = Integer.parseInt(retCode);
        }
        catch (Exception e1) {
            try {
                throw new GameUserException(e1);
            }
            catch (Throwable throwable) {
                SocketUtil.release(socket);
                throw throwable;
            }
        }
        SocketUtil.release(socket);
        return n;
    }

    public int updateUserPwdSafeInfo(int usertype, String account, String secureEmail, String question, String answer, String truename, String cardno, String phone) throws GameUserException {
        byte[] sn = new byte[2];
        this.random.nextBytes(sn);
        byte[] data = new byte[212];
        data[0] = sn[0];
        data[1] = sn[1];
        System.arraycopy(ConstantsCmd.UPDATE_USER_PWDSAFE_CMD, 0, data, 2, 10);
        if (secureEmail == null) {
            secureEmail = "";
        }
        if (question == null) {
            question = "";
        }
        if (answer == null) {
            answer = "";
        }
        if (truename == null) {
            truename = "";
        }
        if (cardno == null) {
            cardno = "";
        }
        if (phone == null) {
            phone = "";
        }
        System.arraycopy(String.valueOf(usertype).getBytes(), 0, data, 12, 1);
        account = CommonUtil.formatString(account, 20, ' ', true);
        System.arraycopy(account.getBytes(), 0, data, 13, 20);
        question = CommonUtil.formatString(question, 50, ' ', true);
        System.arraycopy(question.getBytes(), 0, data, 33, 50);
        answer = CommonUtil.formatString(answer, 50, ' ', true);
        System.arraycopy(answer.getBytes(), 0, data, 83, 50);
        truename = CommonUtil.formatString(truename, 20, ' ', true);
        System.arraycopy(truename.getBytes(), 0, data, 133, 20);
        cardno = CommonUtil.formatString(cardno, 18, ' ', true);
        System.arraycopy(cardno.getBytes(), 0, data, 153, 18);
        phone = CommonUtil.formatString(phone, 11, ' ', true);
        System.arraycopy(phone.getBytes(), 0, data, 171, 11);
        secureEmail = CommonUtil.formatString(secureEmail, 30, ' ', true);
        System.arraycopy(secureEmail.getBytes(), 0, data, 182, 30);
        byte[] lengthBytes = CommonUtil.intToByteArray(data.length);
        try {
            byte[] retByte = SocketUtil.commonRequest2(this.socketAddress, this.port, this.timeout, lengthBytes, data);
            byte[] readLengthBytes = new byte[4];
            System.arraycopy(retByte, 0, readLengthBytes, 0, 4);
            int readLength = CommonUtil.byteArrayToInt(readLengthBytes);
            byte[] readData = new byte[readLength];
            System.arraycopy(retByte, 4, readData, 0, readLength);
            byte[] readSn = new byte[]{readData[0], readData[1]};
            if (readSn[0] != sn[0] || readSn[1] != sn[1]) {
                throw new GameUserException("Invalid sn. ");
            }
            byte[] returnCode = new byte[4];
            System.arraycopy(readData, 2, returnCode, 0, 4);
            String retCode = new String(returnCode).trim();
            return Integer.parseInt(retCode);
        }
        catch (Exception e1) {
            throw new GameUserException(e1);
        }
    }
}

