/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket;

import com.xunlei.proxy.socket.bin.req.Req_getusrinfor;
import com.xunlei.proxy.socket.bin.req.Req_register;
import com.xunlei.proxy.socket.bin.resp.Resp_getusrinfor;
import com.xunlei.proxy.socket.bin.resp.Resp_register;
import com.xunlei.proxy.socket.cbin.XLCbinRecordCodec;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.ValueUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class LoginProxy {
    private static final Logger log = Log.getLogger();
    private static final int sessionIdLen = 128;
    @Config(value="login.host")
    private String host;
    @Config(value="login.port")
    private int port;
    @Config(value="login.timeout")
    private int timeout;
    @Config(value="login.txt.host")
    private String[] txtHost;
    @Config(value="login.txt.port")
    private int[] txtPort;

    public Resp_getusrinfor getusrinfor(String sessionid) {
        if (sessionid == null || sessionid.length() < 128) {
            return new Resp_getusrinfor();
        }
        Resp_getusrinfor resp = new Resp_getusrinfor();
        XLCbinRecordCodec.send(this.host, this.port, this.timeout, new Req_getusrinfor(sessionid), resp);
        return resp;
    }

    public Resp_register register(long userId) {
        Resp_register resp = new Resp_register();
        XLCbinRecordCodec.send(this.host, this.port, this.timeout, new Req_register(userId), resp);
        return resp;
    }

    public LoginInfo validateSessionId(String sessionid) {
        if (sessionid == null || sessionid.length() < 128) {
            return new LoginInfo();
        }
        Object ex = null;
        String resultCode = "";
        try {
            Resp_getusrinfor userinfo = this.getusrinfor(sessionid);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (userinfo != null) {
                resultCode = String.valueOf(userinfo.getResult());
                resultMap.put(Key.account.getName(), (String)((Object)Long.valueOf(userinfo.getAccount())));
                resultMap.put(Key.deadlink.getName(), (String)((Object)Integer.valueOf(userinfo.getDeadlinks())));
                resultMap.put(Key.savetime.getName(), userinfo.getSavetime());
                resultMap.put(Key.dlbytes.getName(), (String)((Object)Long.valueOf(userinfo.getDlfilebytes())));
                resultMap.put(Key.dlfilenum.getName(), (String)((Object)Long.valueOf(userinfo.getDlfilenum())));
                resultMap.put(Key.onlinetime.getName(), userinfo.getOnlinetime());
                resultMap.put(Key.sex.getName(), userinfo.getSex());
                resultMap.put(Key.nickname.getName(), userinfo.getNickname());
                resultMap.put(Key.usertype.getName(), (String)((Object)Integer.valueOf(userinfo.getUsertype())));
                resultMap.put(Key.usrnewno.getName(), (String)((Object)Long.valueOf(userinfo.getUsernewno())));
                resultMap.put(Key.usrname.getName(), userinfo.getUsername());
                resultMap.put(Key.usrid.getName(), String.valueOf(userinfo.getUserno()));
                userinfo.getResult();
            }
            if (!resultCode.equals("200")) {
                throw new Exception("sessionId[" + sessionid + "] validate fail");
            }
            log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.host, this.port, sessionid, "00", ex});
            return new LoginInfo(resultMap);
        }
        catch (Exception e) {
            log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.host, this.port, sessionid, "00", ex});
            return new LoginInfo();
        }
    }

    public static enum Key {
        account("account"),
        blogresult("blogresult"),
        checkans("checkans"),
        checkpwd("checkpwd"),
        deadlink("deadlink"),
        dlbytes("dlbytes"),
        dlfilenum("dlfilenum"),
        isvip("isvip"),
        logintype("logintype"),
        nickname("nickname"),
        onlinetime("onlinetime"),
        order("order"),
        savetime("savetime"),
        score("score"),
        sessionid("sessionid"),
        sex("sex"),
        totalorder("totalorder"),
        upgrade("upgrade"),
        usertype("usertype"),
        usrid("usrid"),
        usrname("usrname"),
        usrnewno("usrnewno");

        private String name;

        private Key(String keyName) {
            this.name = keyName;
        }

        public String getName() {
            return this.name;
        }
    }

    public class LoginInfo {
        private boolean loginSuccess;
        private Map<String, String> map;
        private String orimsg;
        private long userId;

        public LoginInfo() {
            this.loginSuccess = false;
            this.map = Collections.emptyMap();
        }

        public LoginInfo(Map<String, String> map) {
            this.loginSuccess = true;
            this.orimsg = "";
            this.map = map;
        }

        public LoginInfo(Map<String, String> map, String orimsg) {
            this.loginSuccess = true;
            this.orimsg = orimsg;
            this.map = map;
        }

        public String getOrimsg() {
            return this.orimsg;
        }

        public long getUserId() {
            if (this.userId == 0L) {
                this.userId = ValueUtil.getLong(this.getValue(Key.usrid), -1L);
            }
            return this.userId;
        }

        public String getValue(Key key) {
            return this.map.get(key.getName());
        }

        public String getValue(String key) {
            return this.map.get(key);
        }

        public boolean isOk() {
            return this.loginSuccess;
        }

        public String toString() {
            return "LoginInfo [loginSuccess=" + this.loginSuccess + ", map=" + this.map + ", orimsg=" + this.orimsg + "]";
        }
    }
}

