/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy;

import com.xunlei.proxy.SimpleHttpClient;
import com.xunlei.proxy.http.AchievementProxy;
import com.xunlei.proxy.http.FriendProxy;
import com.xunlei.proxy.http.MessageProxy;
import com.xunlei.proxy.http.UserstatusProxy;
import com.xunlei.proxy.http.VipProxy;
import com.xunlei.proxy.socket.HaoProxy;
import com.xunlei.proxy.socket.LoginProxy;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.VerifyProxy;
import com.xunlei.spring.BeanUtil;
import com.xunlei.util.Log;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ProxyFactory {
    private static final Logger log = Log.getLogger();
    public static boolean PROXY_TESTING = ProxyFactory.isProxyTest();
    private static ProxyFactory proxyFactory;
    private static ProxyFactory proxyFactoryTest;
    private AchievementProxy achievementProxy;
    private ApplicationContext context;
    private FriendProxy friendProxy;
    private HaoProxy haoProxy;
    private HttpClient httpClient;
    private LoginProxy loginProxy;
    private MessageProxy messageProxy;
    private UserInfoProxy userInfoProxy;
    private UserstatusProxy userstatusProxy;
    private VerifyProxy verifyProxy;
    private VipProxy vipProxy;

    public static ProxyFactory getInstance() {
        return ProxyFactory.getInstance(PROXY_TESTING);
    }

    public static ProxyFactory getInstance(boolean test) {
        if (test) {
            if (proxyFactoryTest == null) {
                proxyFactoryTest = new ProxyFactory(test);
            }
            return proxyFactoryTest;
        }
        if (proxyFactory == null) {
            proxyFactory = new ProxyFactory(test);
        }
        return proxyFactory;
    }

    public static boolean isProxyTest() {
        InputStream is = ProxyFactory.class.getResourceAsStream("/proxyTesting");
        if (is == null) {
            String info = "ProxyFactory Default Mode: RELEASE\nIf you want to use testing mode:put an empty file named 'proxyTesting' in your classpath";
            log.error(info);
            System.err.println(info);
            return false;
        }
        String info = "ProxyFactory Default Mode: TESTING";
        log.error(info);
        System.err.println(info);
        return true;
    }

    public static void main(String[] args) {
        ProxyFactory.getInstance();
    }

    private ProxyFactory(boolean test) {
        String mainXml = "classpath:com/xunlei/proxy/conf/proxyContext.xml";
        String configXml = test ? "classpath:com/xunlei/proxy/conf/configTestContext.xml" : "classpath:com/xunlei/proxy/conf/configReleaseContext.xml";
        this.context = new ClassPathXmlApplicationContext(new String[]{mainXml, configXml});
    }

    public AchievementProxy getAchievementProxy() {
        if (this.achievementProxy == null) {
            this.achievementProxy = BeanUtil.getTypedBean(this.context, AchievementProxy.class);
        }
        return this.achievementProxy;
    }

    public FriendProxy getFriendProxy() {
        if (this.friendProxy == null) {
            this.friendProxy = BeanUtil.getTypedBean(this.context, FriendProxy.class);
        }
        return this.friendProxy;
    }

    public HaoProxy getHaoProxy() {
        if (this.haoProxy == null) {
            this.haoProxy = BeanUtil.getTypedBean(this.context, HaoProxy.class);
        }
        return this.haoProxy;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = BeanUtil.getTypedBean(this.context, SimpleHttpClient.class);
        }
        return this.httpClient;
    }

    public LoginProxy getLoginProxy() {
        if (this.loginProxy == null) {
            this.loginProxy = BeanUtil.getTypedBean(this.context, LoginProxy.class);
        }
        return this.loginProxy;
    }

    public MessageProxy getMessageProxy() {
        if (this.messageProxy == null) {
            this.messageProxy = BeanUtil.getTypedBean(this.context, MessageProxy.class);
        }
        return this.messageProxy;
    }

    public UserInfoProxy getUserInfoProxy() {
        if (this.userInfoProxy == null) {
            this.userInfoProxy = BeanUtil.getTypedBean(this.context, UserInfoProxy.class);
        }
        return this.userInfoProxy;
    }

    public UserstatusProxy getUserstatusProxy() {
        if (this.userstatusProxy == null) {
            this.userstatusProxy = BeanUtil.getTypedBean(this.context, UserstatusProxy.class);
        }
        return this.userstatusProxy;
    }

    public VerifyProxy getVerifyProxy() {
        if (this.verifyProxy == null) {
            this.verifyProxy = BeanUtil.getTypedBean(this.context, VerifyProxy.class);
        }
        return this.verifyProxy;
    }

    public VipProxy getVipProxy() {
        if (this.vipProxy == null) {
            this.vipProxy = BeanUtil.getTypedBean(this.context, VipProxy.class);
        }
        return this.vipProxy;
    }
}

