/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.task;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.data.giftcenter.vo.PackageGiftNumber;
import com.xunlei.niux.data.giftcenter.vo.PackageHandoutLog;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.util.Log;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class HandoutLogCaller
implements Callable {
    private static Logger logger = Log.getLogger(HandoutLogCaller.class);
    private Long uid;
    private Long packageId;
    private Integer gameType;
    private String giftKey;

    public HandoutLogCaller(Integer gameType, Long packageId, Long uid, String giftKey) {
        this.gameType = gameType;
        this.packageId = packageId;
        this.uid = uid;
        this.giftKey = giftKey;
    }

    public Object call() throws Exception {
        Object gift;
        BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
        PackageHandoutLog log = new PackageHandoutLog();
        log.setUid(this.uid);
        log.setLogTime(DateUtil.formatNowByDefault());
        log.setPackageId(this.packageId);
        log.setGameType(this.gameType);
        log.setGiftKey(this.giftKey);
        if (this.gameType == 1) {
            gift = baseSo.findById(PackageWebgameGift.class, this.packageId);
            if (gift == null) {
                throw new XLRuntimeException("not found packageId=" + this.packageId + ", gameType=" + this.gameType);
            }
            log.setPackageName(((PackageWebgameGift)gift).getPackageName());
            log.setPackageStartTime(((PackageWebgameGift)gift).getStartTime());
            log.setPackageEndTime(((PackageWebgameGift)gift).getEndTime());
            log.setGameId(((PackageWebgameGift)gift).getGameId());
            log.setPlatformId(((PackageWebgameGift)gift).getPlatformId());
        } else if (this.gameType == 2) {
            gift = baseSo.findById(PackageMobilegameGift.class, this.packageId);
            if (gift == null) {
                throw new XLRuntimeException("not found packageId=" + this.packageId + ", gameType=" + this.gameType);
            }
            log.setPackageName(((PackageMobilegameGift)gift).getPackageName());
            log.setPackageStartTime(((PackageMobilegameGift)gift).getStartTime());
            log.setPackageEndTime(((PackageMobilegameGift)gift).getEndTime());
            log.setGameId(((PackageMobilegameGift)gift).getGameId());
            log.setPlatformId(((PackageMobilegameGift)gift).getPlatformId());
        } else {
            throw new XLRuntimeException("bad gameType packageId=" + this.packageId + ", gameType=" + this.gameType);
        }
        PackageManufacturer plat = baseSo.findById(PackageManufacturer.class, log.getPlatformId());
        log.setPackageName(plat.getPlatform());
        PackageGames game = baseSo.findById(PackageGames.class, log.getGameId());
        log.setGameName(game.getGameName());
        PackageGiftNumber queryNum = new PackageGiftNumber();
        queryNum.setGameType(this.gameType);
        queryNum.setPackageId(this.packageId);
        PackageGiftNumber num = baseSo.findObject(queryNum);
        log.setLogNumTotal(num.getTotal());
        log.setLogNumUsed(num.getUsed());
        baseSo.addObject(log);
        return "";
    }
}

