/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.task;

import com.xunlei.util.Log;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class AsyncExecutor {
    private static Logger logger = Log.getLogger(AsyncExecutor.class);
    private static final AsyncExecutor instance = new AsyncExecutor();
    private ExecutorService executor = new ThreadPoolExecutor(5, 10, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500000), new ThreadPoolExecutor.DiscardOldestPolicy());

    public static AsyncExecutor getInstance() {
        return instance;
    }

    private AsyncExecutor() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("AsyncExecutor().destroy()");
                AsyncExecutor.getInstance().destroy();
                logger.info("AsyncExecutor.getInstance().destroy()");
            }
        });
    }

    public void execute(Callable task) {
        try {
            this.executor.submit(task);
        }
        catch (Throwable e) {
            logger.error("AsyncExecutor to add task", e);
        }
    }

    public void addTask(List<Callable> taskList) {
        for (Callable task : taskList) {
            this.execute(task);
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

