/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.proxy;

import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;

public class JRedisProxy {
    private static JRedisProxy jRedisProxy = new JRedisProxy();
    private static Logger logger = Logger.getLogger("redisLoger");
    private static final String host = EnvPropertyUtil.loadProperty("jredis", "host");
    private static final String port = EnvPropertyUtil.loadProperty("jredis", "port");
    private static final String maxActive = EnvPropertyUtil.loadProperty("jredis", "maxActive");
    private static final String maxIdle = EnvPropertyUtil.loadProperty("jredis", "maxIdle");
    private Properties config = new Properties();
    private JedisPool pool;

    public static JRedisProxy getInstance() {
        return jRedisProxy;
    }

    private JRedisProxy() {
        try {
            System.out.println("jredis system\u8fde\u63a5 \u521d\u59cb\u5316");
            String fileName = "/jredis.properties";
            String env = EnvPropertyUtil.getEnv();
            String filePath = StringUtils.isNotEmpty(env) ? "/" + env + fileName : fileName;
            System.out.println("fileName\uff1a" + fileName);
            System.out.println("filePath\uff1a" + filePath);
            InputStream is = Object.class.getResourceAsStream(filePath);
            this.config.load(is);
            if (is != null) {
                is.close();
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxActive(Integer.parseInt(this.config.getProperty("maxActive", "1000")));
            poolConfig.setMaxIdle(Integer.parseInt(this.config.getProperty("maxIdle", "30")));
            poolConfig.setMaxWait(Integer.parseInt(this.config.getProperty("maxWait", "1000")));
            poolConfig.setTestOnBorrow(false);
            poolConfig.setTestOnReturn(false);
            this.pool = new JedisPool(poolConfig, this.config.getProperty("host"), Integer.parseInt(this.config.getProperty("port", "6379")));
        }
        catch (Exception e) {
            System.out.println("jredis system\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value, int seconds) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.setex(key, seconds, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("jredisSet\u5f02\u5e38\uff1akey=" + key + ",value=" + value + ",seconds=" + seconds, e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String value = null;
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            value = jedis.get(key);
        }
        catch (Exception e) {
            logger.info("jredisget\u5f02\u5e38\uff1akey=" + key + ",value=" + value, e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.del(key);
        }
        catch (Exception e) {
            logger.info("jredisdel\u5f02\u5e38\uff1akey=" + key, e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setByPipeline(Map<String, String> map, int seconds) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                pipeline.setex(entry.getKey(), seconds, entry.getValue());
            }
            pipeline.sync();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("setByPipeline\uff1amap=" + map + ",seconds=" + seconds, e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            long ttl = jedis.ttl(key);
            if (ttl > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.info("jredisEsists\u5f02\u5e38\uff1akey=" + key, e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incr(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.incr(key);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("jredisIncr\u5f02\u5e38\uff1akey=" + key);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incr(String key, int expire) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.incr(key);
            jedis.expire(key, expire);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("jredisIncr\u5f02\u5e38\uff1akey=" + key);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource(jedis);
            }
        }
        return false;
    }

    public void test() {
        try {
            Jedis jedis = (Jedis)this.pool.getResource();
            if (this.exists("000120_1_ROLE_FIGHT")) {
                System.out.println(true);
            }
            this.pool.returnBrokenResource(jedis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JRedisProxy.getInstance().test();
    }
}

