/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.user;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.json.JSONUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.BookingGiftRecord;
import com.xunlei.niux.giftcenter.cmd.DefaultAbstractCmd;
import com.xunlei.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserRecordCmd
extends DefaultAbstractCmd {
    private static Logger logger = Log.getLogger(UserRecordCmd.class.getName());

    @CmdMapper(value={"/user/myGift.do"})
    public Object myGift(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            int pageNo = request.getParameterInteger("pageNo", 1);
            int pageSize = request.getParameterInteger("pageSize", 20);
            String gameTypeStr = request.getParameter("gameType");
            int gameType = 0;
            if (StringUtils.isNotEmpty(gameTypeStr)) {
                gameType = Integer.valueOf(gameTypeStr);
            }
            List<Object> list = new ArrayList();
            int cnt = FacadeFactory.INSTANCE.getXlGiftCenterBo().countUserGiftRecord(uid, gameType);
            if (cnt > 0) {
                list = FacadeFactory.INSTANCE.getXlGiftCenterBo().getUserGiftRecord(uid, gameType, pageNo, pageSize);
            }
            HashMap<String, Serializable> object = new HashMap<String, Serializable>();
            object.put("rtn", Integer.valueOf(0));
            object.put("count", Integer.valueOf(cnt));
            object.put("data", (Serializable)((Object)list));
            return JSONUtil.fromObject(object);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/user/myBooking.do"})
    public Object myBooking(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            int pageNo = request.getParameterInteger("pageNo", 1);
            int pageSize = request.getParameterInteger("pageSize", 20);
            BookingGiftRecord query = new BookingGiftRecord();
            query.setUid(uid);
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("bookTime", OrderType.DESC);
            int cnt = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
            List<BookingGiftRecord> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
            HashMap<String, Object> object = new HashMap<String, Object>();
            object.put("rtn", 0);
            object.put("count", cnt);
            object.put("data", list);
            return JSONUtil.fromObject(object);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

