/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageWebGameServerTest;
import com.xunlei.niux.giftcenter.cmd.manufacturer.ManufacturerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebGameServerTestCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebGameServerTestCmd.class);

    private String check(PackageWebGameServerTest open) {
        if (open == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
        }
        if (open.getGameid() == null || open.getGameid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u6e38\u620fid");
        }
        if (open.getGiftid() == null || open.getGiftid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305id");
        }
        if (StringUtils.isEmpty(open.getTesttime())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u6d4b\u65f6\u95f4");
        }
        if (StringUtils.isEmpty(open.getTestday())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u6d4b\u65e5\u671f");
        }
        if (StringUtils.isEmpty(open.getUrl())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5b98\u7f51URL");
        }
        if (open.getServerid() == null || open.getServerid() < 1) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u533a\u670did");
        }
        return "0";
    }

    @CmdMapper(value={"/webGameServer/testServerList.do"})
    public Object testServerList(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            int pageSize = request.getParameterInteger("pageSize", 20);
            int pageNo = request.getParameterInteger("pageNo", 1);
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("applyTime", OrderType.DESC);
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            MainParam mainParam = this.getMainParam(request, response, true);
            String account = mainParam.getUserid() + "";
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setUserid(account);
            manufacturer.setStatus(1);
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(manufacturer);
            if (manufacturer == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u6743\u9650");
            }
            String check = ManufacturerUtils.check(mainParam, account, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageWebGameServerTest open = this.getWebGameServerTest(request, null);
            List<PackageWebGameServerTest> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(open, page);
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(open);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", count);
            map.put("list", list);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("testServerList.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/webGameServer/testServer.do"})
    public Object testServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageWebGameServerTest test = this.getWebGameServerTest(request, null);
            String checkStr = this.check(test);
            if (!checkStr.equals("0")) {
                return checkStr;
            }
            test.setApplyTime(ManufacturerUtils.now());
            test.setPlatformId(manufactorerId);
            test.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().addObject(test);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("testServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/webGameServer/alterTestServer.do"})
    public Object AlterTestServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            Long seqId = request.getParameterLong("seqid");
            if (seqId == null || seqId == 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6761\u4ef6\u4e0d\u8db3");
            }
            PackageWebGameServerTest byId = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebGameServerTest.class, seqId);
            if (byId == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u8be5\u6761\u8bb0\u5f55");
            }
            if (byId.getPlatformId().longValue() != manufactorerId.longValue()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u6ca1\u6709\u8be5\u8bb0\u5f55\u6743\u9650");
            }
            PackageWebGameServerTest open = this.getWebGameServerTest(request, byId);
            String checkStr = this.check(open);
            if (!checkStr.equals("0")) {
                return checkStr;
            }
            open.setApplyTime(ManufacturerUtils.now());
            open.setPlatformId(manufactorerId);
            open.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(open);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("alterTestServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private PackageWebGameServerTest getWebGameServerTest(XLHttpRequest request, PackageWebGameServerTest test) {
        String url;
        Long giftId;
        Integer type;
        String testtime;
        String testday;
        Integer serverid;
        Long gameId;
        if (test == null) {
            test = new PackageWebGameServerTest();
        }
        if ((gameId = Long.valueOf(request.getParameterLong("gameId", -9L))) != null && gameId > 0L) {
            test.setGameid(gameId);
        }
        if ((serverid = Integer.valueOf(request.getParameterInteger("serverid", -9))) != null && serverid > 0) {
            test.setServerid(serverid);
        }
        if (StringUtils.isNotEmpty(testday = request.getParameter("testday"))) {
            test.setTestday(testday);
        }
        if (StringUtils.isNotEmpty(testtime = request.getParameter("testtime"))) {
            test.setTesttime(testtime);
        }
        if ((type = Integer.valueOf(request.getParameterInteger("type", -9))) != null && type > 0) {
            test.setType(type);
        }
        if ((giftId = Long.valueOf(request.getParameterLong("giftid", -9L))) != null && giftId > 0L) {
            test.setGiftid(giftId);
        }
        if (StringUtils.isNotEmpty(url = request.getParameter("url"))) {
            test.setUrl(url);
        }
        return test;
    }

    @CmdMapper(value={"/webGameServer/testServerTimeList.do"})
    public Object openServerTimeList(XLHttpRequest request, XLHttpResponse response) {
        int pageNo = request.getParameterInteger("pageNo", 0);
        int pageSize = request.getParameterInteger("pageSize", 20);
        List<Map<String, Object>> webGameServerTests = FacadeFactory.INSTANCE.getPackageWebGameServerTestBo().getWebGameServerTests(pageNo, pageSize, null);
        PackageWebGameServerTest packageWebGameServerTest = new PackageWebGameServerTest();
        packageWebGameServerTest.setStatus(1);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(packageWebGameServerTest);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", count);
        map.put("list", webGameServerTests);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }
}

