/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameServerOpen;
import com.xunlei.niux.giftcenter.cmd.manufacturer.ManufacturerUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebGameServerOpenCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebGameServerOpenCmd.class);

    private PackageWebgameServerOpen getWebServerOpen(XLHttpRequest request, PackageWebgameServerOpen open) {
        Integer serverId;
        String url;
        Long giftid;
        String opentime;
        String openday;
        Long gameId;
        if (open == null) {
            open = new PackageWebgameServerOpen();
        }
        if ((gameId = Long.valueOf(request.getParameterLong("gameid", -1L))) != null && gameId > 0L) {
            open.setGameid(gameId);
        }
        if (StringUtils.isNotEmpty(openday = request.getParameter("openday"))) {
            open.setOpenday(openday);
        }
        if (StringUtils.isNotEmpty(opentime = request.getParameter("opentime"))) {
            open.setOpentime(opentime);
        }
        if ((giftid = Long.valueOf(request.getParameterLong("giftid", -1L))) != null && giftid > 0L) {
            open.setGiftid(giftid);
        }
        if (StringUtils.isNotEmpty(url = request.getParameter("url"))) {
            open.setUrl(url);
        }
        if ((serverId = Integer.valueOf(request.getParameterInteger("serverid", -1))) != null && serverId > 0) {
            open.setServerid(serverId);
        }
        return open;
    }

    private String check(PackageWebgameServerOpen open) {
        if (open == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
        }
        if (open.getGameid() == null || open.getGameid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u6e38\u620fid");
        }
        if (open.getGiftid() == null || open.getGiftid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305id");
        }
        if (StringUtils.isEmpty(open.getOpentime())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u670d\u65f6\u95f4");
        }
        if (StringUtils.isEmpty(open.getOpenday())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u670d\u65e5\u671f");
        }
        if (StringUtils.isEmpty(open.getUrl())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5b98\u7f51URL");
        }
        if (open.getServerid() == null || open.getServerid() < 1) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u533a\u670did");
        }
        return "0";
    }

    @CmdMapper(value={"/webGameServer/openServer.do"})
    public Object openServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageWebgameServerOpen open = this.getWebServerOpen(request, null);
            String checkStr = this.check(open);
            if (!checkStr.equals("0")) {
                return checkStr;
            }
            open.setApplyTime(ManufacturerUtils.now());
            open.setPlatformId(manufactorerId);
            open.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().addObject(open);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("openServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/webGameServer/openServerList.do"})
    public Object openServerList(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            int pageSize = request.getParameterInteger("pageSize", 20);
            int pageNo = request.getParameterInteger("pageNo", 1);
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("applyTime", OrderType.DESC);
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
            }
            MainParam mainParam = this.getMainParam(request, response, true);
            String account = mainParam.getUserid() + "";
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setUserid(account);
            manufacturer.setStatus(1);
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(manufacturer);
            if (manufacturer == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u6743\u9650");
            }
            String check = ManufacturerUtils.check(mainParam, account, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageWebgameServerOpen open = this.getWebServerOpen(request, null);
            open.setPlatformId(manufactorerId);
            List<PackageWebgameServerOpen> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(open, page);
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(open);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", count);
            map.put("list", list);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("openServerList.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/webGameServer/alterOpenServer.do"})
    public Object AlterOpenServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            Long seqId = request.getParameterLong("seqid");
            if (seqId == null || seqId == 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6761\u4ef6\u4e0d\u8db3");
            }
            PackageWebgameServerOpen byId = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameServerOpen.class, seqId);
            if (byId == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u8be5\u6761\u8bb0\u5f55");
            }
            if (byId.getPlatformId().longValue() != manufactorerId.longValue()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u6ca1\u6709\u8be5\u8bb0\u5f55\u6743\u9650");
            }
            PackageWebgameServerOpen open = this.getWebServerOpen(request, byId);
            String checkStr = this.check(open);
            if (!checkStr.equals("0")) {
                return checkStr;
            }
            open.setApplyTime(ManufacturerUtils.now());
            open.setPlatformId(manufactorerId);
            open.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(open);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("alterOpenServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/webGameServer/openServerTimeList.do"})
    public Object openServerTimeList(XLHttpRequest request, XLHttpResponse response) {
        int pageNo = request.getParameterInteger("pageNo", 0);
        int pageSize = request.getParameterInteger("pageSize", 20);
        String day = request.getParameter("day");
        if (StringUtils.isEmpty(day)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u7f3a\u5c11\u53c2\u6570");
        }
        String timeStr = "";
        int time = request.getParameterInteger("time", 8);
        try {
            Date date = DateUtils.parseDate(day, new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
            day = DateFormatUtils.format(date, "yyyy-MM-dd");
            timeStr = String.valueOf(time);
            timeStr = timeStr.length() == 1 ? "0" + timeStr + ":00:00" : timeStr + ":00:00";
        }
        catch (ParseException e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List<Map<String, Object>> array = FacadeFactory.INSTANCE.getPackageWebGameServerOpenBo().getWebGameServerOpensByTime(day, timeStr, pageNo, pageSize);
        PackageWebgameServerOpen open = new PackageWebgameServerOpen();
        open.setOpenday(day);
        open.setOpentime(timeStr);
        open.setStatus(1);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(open);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", count);
        map.put("list", array);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }
}

