/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageMobileGameTest;
import com.xunlei.niux.giftcenter.cmd.manufacturer.ManufacturerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MobileGameTestCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileGameTestCmd.class);

    @CmdMapper(value={"/mobileGame/testServer.do"})
    public Object testServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageMobileGameTest test = this.getMobileGameTest(request, null);
            test.setApplyTime(ManufacturerUtils.now());
            test.setPlatformId(manufactorerId);
            test.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().addObject(test);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("testServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/mobileGame/testServerList.do"})
    public Object testServerList(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            int pageSize = request.getParameterInteger("pageSize", 20);
            int pageNo = request.getParameterInteger("pageNo", 1);
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("applyTime", OrderType.DESC);
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            MainParam mainParam = this.getMainParam(request, response, true);
            String account = mainParam.getUserid() + "";
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setUserid(account);
            manufacturer.setStatus(1);
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(manufacturer);
            if (manufacturer == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u6743\u9650");
            }
            String check = ManufacturerUtils.check(mainParam, account, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageMobileGameTest open = this.getMobileGameTest(request, null);
            List<PackageMobileGameTest> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(open, page);
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(open);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", count);
            map.put("list", list);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("testServerList.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/mobileGame/alterTestServer.do"})
    public Object AlterTestServer(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            Long seqId = request.getParameterLong("seqid");
            if (seqId == null || seqId == 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6761\u4ef6\u4e0d\u8db3");
            }
            PackageMobileGameTest byId = FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobileGameTest.class, seqId);
            if (byId == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u8be5\u6761\u8bb0\u5f55");
            }
            if (byId.getPlatformId().longValue() != manufactorerId.longValue()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u6ca1\u6709\u8be5\u8bb0\u5f55\u6743\u9650");
            }
            PackageMobileGameTest open = this.getMobileGameTest(request, byId);
            String checkStr = this.check(open);
            if (!checkStr.equals("0")) {
                return checkStr;
            }
            open.setApplyTime(ManufacturerUtils.now());
            open.setPlatformId(manufactorerId);
            open.setStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(open);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("alterTestServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private String check(PackageMobileGameTest test) {
        if (test == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
        }
        if (test.getGameid() == null || test.getGameid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u6e38\u620fid");
        }
        if (test.getGiftid() == null || test.getGiftid() < 1L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305id");
        }
        if (StringUtils.isEmpty(test.getTestday())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u6d4b\u65e5\u671f");
        }
        if (StringUtils.isEmpty(test.getTesttime())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u6d4b\u65f6\u95f4");
        }
        if (StringUtils.isEmpty(test.getGameUrl())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5b98\u7f51URL");
        }
        if (test.getType() == null || test.getType() < 1) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u6d4b\u8bd5\u7c7b\u578b");
        }
        return "0";
    }

    private PackageMobileGameTest getMobileGameTest(XLHttpRequest request, PackageMobileGameTest test) {
        Long giftid;
        String gameUrl;
        String androidUrl;
        String iosUrl;
        Integer type;
        String testtime;
        String testday;
        Long gameId;
        if (test == null) {
            test = new PackageMobileGameTest();
        }
        if ((gameId = Long.valueOf(request.getParameterLong("gameId", -1L))) != null && gameId > 0L) {
            test.setGameid(gameId);
        }
        if (StringUtils.isNotEmpty(testday = request.getParameter("testday"))) {
            test.setTestday(testday);
        }
        if (StringUtils.isNotEmpty(testtime = request.getParameter("testtime"))) {
            test.setTesttime(testtime);
        }
        if ((type = Integer.valueOf(request.getParameterInteger("type", -1))) != null && type > 0) {
            test.setType(type);
        }
        if (StringUtils.isNotEmpty(iosUrl = request.getParameter("iosUrl"))) {
            test.setIosurl(iosUrl);
        }
        if (StringUtils.isNotEmpty(androidUrl = request.getParameter("androidUrl"))) {
            test.setAndroidurl(androidUrl);
        }
        if (StringUtils.isNotEmpty(gameUrl = request.getParameter("gameUrl"))) {
            test.setGameUrl(gameUrl);
        }
        if ((giftid = Long.valueOf(request.getParameterLong("giftid", -9L))) != null && giftid > 0L) {
            test.setGiftid(giftid);
        }
        return test;
    }

    @CmdMapper(value={"/mobileGame/testServerTimeList.do"})
    public Object testServerTimeList(XLHttpRequest request, XLHttpResponse response) {
        int pageNo = request.getParameterInteger("pageNo", 0);
        int pageSize = request.getParameterInteger("pageSize", 20);
        List<Map<String, Object>> mobileServerTests = FacadeFactory.INSTANCE.getPackageMobileGameTestBo().getMobileGameTest(pageNo, pageSize, null);
        PackageMobileGameTest test = new PackageMobileGameTest();
        test.setStatus(1);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(test);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", count);
        map.put("list", mobileServerTests);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }
}

