/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftApply;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKeyApply;
import com.xunlei.niux.giftcenter.cmd.manufacturer.ManufacturerUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MobileGameServerGiftCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileGameServerGiftCmd.class);

    @CmdMapper(value={"/giftcenter/mobile/publishGift.do"})
    public Object publishGift(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageMobilegameGiftApply gift = this.getMobileGameServerGift(request, null);
            String checkParamter = this.checkParamter(gift);
            if (!checkParamter.equals("0")) {
                return checkParamter;
            }
            gift.setApplyTime(ManufacturerUtils.now());
            gift.setPlatformId(manufactorerId);
            gift.setPackageStatus(0);
            FacadeFactory.INSTANCE.getBaseSo().addObject(gift);
            gift = FacadeFactory.INSTANCE.getBaseSo().findObject(gift);
            String serializes = request.getParameter("serializes");
            if (StringUtils.isEmpty(serializes)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u5fc5\u987b\u586b\u5199\u6fc0\u6d3b\u7801");
            }
            String[] split = serializes.split("[\n\r\t,\\s]+");
            HashSet<String> keys = new HashSet<String>(split.length);
            for (String key : split) {
                if (!keys.add(key)) continue;
                PackageMobilegameGiftKeyApply keyApply = new PackageMobilegameGiftKeyApply();
                keyApply.setGameId(gift.getGameId());
                keyApply.setPackageId(gift.getSeqid());
                keyApply.setGiftKey(key);
                keyApply.setPlatformId(manufactorerId);
                keyApply.setKeyStatus(0);
                FacadeFactory.INSTANCE.getBaseSo().addObject(keyApply);
            }
            keys = null;
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("mobile/publishGift.do\u767b\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/giftcenter/mobile/getGiftList.do"})
    public Object getGiftList(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            int pageSize = request.getParameterInteger("pageSize", 20);
            int pageNo = request.getParameterInteger("pageNo", 1);
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("applyTime", OrderType.DESC);
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            PackageMobilegameGiftApply gift = this.getMobileGameServerGift(request, null);
            gift.setPlatformId(manufactorerId);
            page.addOrder("applyTime", OrderType.DESC);
            List<PackageMobilegameGiftApply> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(gift, page);
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(gift);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", count);
            map.put("list", list);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("mobile/publishGift.do\u767b\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private PackageMobilegameGiftApply getMobileGameServerGift(XLHttpRequest request, PackageMobilegameGiftApply gift) {
        String androdiUrl;
        String iosUrl;
        String regesterUrl;
        Integer needPhone;
        Integer needXLVip;
        String endTime;
        String startTime;
        String activationTips;
        String packageContent;
        String packageName;
        Long gameId;
        if (gift == null) {
            gift = new PackageMobilegameGiftApply();
        }
        if ((gameId = Long.valueOf(request.getParameterLong("gameId", -1L))) != null && gameId > 0L) {
            gift.setGameId(gameId);
        }
        if (StringUtils.isNotEmpty(packageName = request.getParameter("packageName"))) {
            gift.setPackageName(packageName);
        }
        if (StringUtils.isNotEmpty(packageContent = request.getParameter("packageContent"))) {
            gift.setPackageContent(packageContent);
        }
        if (StringUtils.isNotEmpty(activationTips = request.getParameter("activationTips"))) {
            gift.setActivationTips(activationTips);
        }
        if (StringUtils.isNotEmpty(startTime = request.getParameter("startTime"))) {
            gift.setStartTime(startTime);
        }
        if (StringUtils.isNotEmpty(endTime = request.getParameter("endTime"))) {
            gift.setEndTime(endTime);
        }
        if ((needXLVip = Integer.valueOf(request.getParameterInteger("needXLVip", -9))) != null & needXLVip > -9) {
            gift.setNeedXLVip(needXLVip);
        }
        if ((needPhone = Integer.valueOf(request.getParameterInteger("needPhone", -9))) != null && needPhone > -9) {
            gift.setNeedPhone(needPhone);
        }
        if (StringUtils.isNotEmpty(regesterUrl = request.getParameter("regesterUrl"))) {
            gift.setRegesterUrl(regesterUrl);
        }
        if (StringUtils.isNotEmpty(iosUrl = request.getParameter("iosUrl"))) {
            gift.setIosUrl(iosUrl);
        }
        if (StringUtils.isNotEmpty(androdiUrl = request.getParameter("androidUrl"))) {
            gift.setAndroidUrl(androdiUrl);
        }
        return gift;
    }

    private String checkParamter(PackageMobilegameGiftApply gift) {
        if (gift.getGameId() == null || gift.getGameId() <= 0L) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u6e38\u620fid");
        }
        if (StringUtils.isEmpty(gift.getPackageName())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305\u540d\u79f0");
        }
        if (StringUtils.isEmpty(gift.getPackageContent())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305\u5185\u5bb9");
        }
        if (StringUtils.isEmpty(gift.getActivationTips())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u793c\u5305\u4f7f\u7528\u65b9\u6cd5");
        }
        if (StringUtils.isEmpty(gift.getStartTime())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u5f00\u59cb\u65f6\u95f4");
        }
        if (StringUtils.isEmpty(gift.getEndTime())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8bf7\u8f93\u5165\u7ed3\u675f\u65f6\u95f4");
        }
        return "0";
    }
}

