/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.giftcenter.cmd.manufacturer.ManufacturerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManufacturerDictionaryCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturerDictionaryCmd.class);

    @CmdMapper(value={"/dictionary/webGameLists.do"})
    public Object webGames(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        List<Map<String, Object>> rtnlist = this.getTypeGames(1);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, rtnlist);
    }

    @CmdMapper(value={"/dictionary/mobileGameLists.do"})
    public Object mobileGames(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        List<Map<String, Object>> rtnlist = this.getTypeGames(2);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, rtnlist);
    }

    private List<Map<String, Object>> getTypeGames(Integer type) {
        PackageGames query = new PackageGames();
        query.setGameType(type);
        Page page = new Page();
        page.addOrder("editTime", OrderType.DESC);
        List<PackageGames> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        ArrayList<Map<String, Object>> rtnlist = new ArrayList<Map<String, Object>>();
        for (PackageGames games : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", games.getSeqid());
            map.put("gameName", games.getGameName());
            rtnlist.add(map);
        }
        return rtnlist;
    }

    @CmdMapper(value={"/dictionary/getWebGifts.do"})
    public Object getWebGifts(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            Long gameId = request.getParameterLong("gameId", 0L);
            PackageWebgameGift gift = new PackageWebgameGift();
            gift.setPlatformId(manufactorerId);
            gift.setPackageStatus(1);
            if (gameId != null && gameId > 0L) {
                gift.setGameId(gameId);
            }
            Page page = new Page();
            page.addOrder("applyTime", OrderType.DESC);
            List<PackageWebgameGift> gifts = FacadeFactory.INSTANCE.getBaseSo().findObjects(gift, page);
            ArrayList list = new ArrayList();
            for (PackageWebgameGift g : gifts) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("giftId", g.getSeqid());
                map.put("giftName", g.getPackageName());
                list.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("alterTestServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/dictionary/getMobileGifts.do"})
    public Object getMobileGifts(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            Long manufactorerId = request.getParameterLong("manufactorerId", -1L);
            if (manufactorerId < 1L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String check = ManufacturerUtils.check(mainParam, userId, manufactorerId);
            if (!check.equals("0")) {
                return check;
            }
            Long gameId = request.getParameterLong("gameId", 0L);
            PackageMobilegameGift gift = new PackageMobilegameGift();
            gift.setPlatformId(manufactorerId);
            gift.setPackageStatus(1);
            if (gameId != null && gameId > 0L) {
                gift.setGameId(gameId);
            }
            Page page = new Page();
            page.addOrder("applyTime", OrderType.DESC);
            List<PackageMobilegameGift> gifts = FacadeFactory.INSTANCE.getBaseSo().findObjects(gift, page);
            ArrayList list = new ArrayList();
            for (PackageMobilegameGift g : gifts) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("giftId", g.getSeqid());
                map.put("giftName", g.getPackageName());
                list.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("alterTestServer.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }
}

