/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.manufacturer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturerApply;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManufacturerCmd
extends DefaultCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturerCmd.class);

    @CmdMapper(value={"/manufacturerlogin.do"})
    public Object login(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            Integer status;
            MainParam mainParam = this.getMainParam(request, response, true);
            long account = mainParam.getUserid();
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setUserid(account + "");
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(manufacturer);
            if (manufacturer == null) {
                PackageManufacturerApply apply = new PackageManufacturerApply();
                apply.setApplyid(account + "");
                apply = FacadeFactory.INSTANCE.getBaseSo().findObject(apply);
                if (apply == null) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u8bf7\u7533\u8bf7");
                }
                if (apply.getStatus() == 0) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-6, "\u7b49\u5f85\u5ba1\u6279\uff0c\u8bf7\u7a0d\u7b49");
                }
                if (apply.getStatus() == -1) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u7533\u8bf7\u5931\u8d25\uff1a" + apply.getFailreason());
                }
                if (apply.getStatus() == 1) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            }
            if ((status = manufacturer.getStatus()) == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u7533\u8bf7\u4e2d");
            }
            if (status == -1) {
                PackageManufacturerApply apply = new PackageManufacturerApply();
                apply.setManufacturerid(manufacturer.getSeqid());
                apply.setStatus(-1);
                Page page = new Page();
                page.addOrder("applydate", OrderType.DESC);
                List<PackageManufacturerApply> applies = FacadeFactory.INSTANCE.getBaseSo().findObjects(apply, page);
                if (applies == null || applies.size() == 0) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-4, "\u6ca1\u6709\u7533\u8bf7\u8bb0\u5f55");
                }
                apply = applies.get(0);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u7533\u8bf7\u5931\u8d25:" + apply.getFailreason());
            }
            if (status != 1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u8d44\u6599\u8fc7\u671f");
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, manufacturer);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("manufacturerlogin.do\u767b\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private String check(PackageManufacturer manufacturer) {
        String contacts = manufacturer.getContacts();
        String phone = manufacturer.getPhone();
        String cardid = manufacturer.getCardid();
        String qq = manufacturer.getQq();
        String email = manufacturer.getEmail();
        int platformtype = manufacturer.getPlatformtype();
        String platform = manufacturer.getPlatform();
        String platformurl = manufacturer.getPlatformurl();
        if (StringUtils.isEmpty(contacts)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(phone) || !phone.matches("^[1][358][0-9]{9}$")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8054\u7cfb\u7535\u8bdd\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty(cardid) || !cardid.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|X)$")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty(qq) || !qq.matches("[1-9]\\d{5,12}")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "QQ\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty(email) || !email.matches("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "EMAIL\u4e0d\u6b63\u786e");
        }
        if (platformtype <= 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u5e73\u53f0\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty(platform) && platform.length() > 5) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u5e73\u53f0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u8d85\u8fc75\u4e2a\u5b57");
        }
        if (StringUtils.isEmpty(platformurl) || !platformurl.startsWith("http://")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u5e73\u53f0\u5b98\u7f51URL");
        }
        return "0";
    }

    private PackageManufacturer getManufacturer(XLHttpRequest request, PackageManufacturer manufacturer) {
        if (manufacturer == null) {
            manufacturer = new PackageManufacturer();
        }
        try {
            String platformurl;
            String platform;
            int platformtype;
            String email;
            String qq;
            String cardid;
            String phone;
            String contacts = request.getParameter("contacts", "");
            if (StringUtils.isNotEmpty(contacts)) {
                manufacturer.setContacts(contacts);
            }
            if (StringUtils.isNotEmpty(phone = request.getParameter("phone", ""))) {
                manufacturer.setPhone(phone);
            }
            if (StringUtils.isNotEmpty(cardid = request.getParameter("cardid", ""))) {
                manufacturer.setCardid(cardid);
            }
            if (StringUtils.isNotEmpty(qq = request.getParameter("qq", ""))) {
                manufacturer.setQq(qq);
            }
            if (StringUtils.isNotEmpty(email = request.getParameter("email", ""))) {
                manufacturer.setEmail(email);
            }
            if ((platformtype = request.getParameterInteger("platformtype", 0)) > 0) {
                manufacturer.setPlatformtype(platformtype);
            }
            if (StringUtils.isNotEmpty(platform = request.getParameter("platform", ""))) {
                manufacturer.setPlatform(platform);
            }
            if (StringUtils.isNotEmpty(platformurl = request.getParameter("platformurl", ""))) {
                manufacturer.setPlatformurl(platformurl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("\u53c2\u6570\u4f20\u9012\u6709\u8bef", (Object)e.getMessage());
            throw new XLRuntimeException("\u53c2\u6570\u4f20\u9012\u6709\u8bef");
        }
        return manufacturer;
    }

    @CmdMapper(value={"/manufacturer/apply.do"})
    public Object apply(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String account = mainParam.getUserid() + "";
            PackageManufacturer insert = this.getManufacturer(request, null);
            String check = this.check(insert);
            if (!check.equals("0")) {
                return check;
            }
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setStatus(1);
            manufacturer.setUserid(account);
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(manufacturer);
            if (manufacturer != null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u8be5\u5e10\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u5382\u5546\uff1a" + manufacturer.getPlatform());
            }
            insert.setStatus(0);
            insert.setEdittime(DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            insert.setEditby(account);
            FacadeFactory.INSTANCE.getBaseSo().addObject(insert);
            manufacturer = FacadeFactory.INSTANCE.getBaseSo().findObject(insert);
            PackageManufacturerApply apply = new PackageManufacturerApply();
            apply.setStatus(0);
            apply.setApplyid(account);
            apply.setManufacturerid(manufacturer.getSeqid());
            apply.setApplydate(DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            FacadeFactory.INSTANCE.getBaseSo().addObject(apply);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("apply.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/manufacturer/alterApply.do"})
    public Object AlterApply(XLHttpRequest request, XLHttpResponse response) {
        try {
            String check;
            long seqid = request.getParameterLong("seqid");
            if (seqid <= 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u4f20\u9012\u6709\u8bef");
            }
            MainParam mainParam = this.getMainParam(request, response, true);
            String account = mainParam.getUserid() + "";
            PackageManufacturer manufacturer = new PackageManufacturer();
            manufacturer.setSeqid(seqid);
            manufacturer = (PackageManufacturer)FacadeFactory.INSTANCE.getBaseSo().findById(manufacturer.getClass(), manufacturer.getSeqid());
            manufacturer = this.getManufacturer(request, manufacturer);
            if (!account.equals(manufacturer.getUserid())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u8bf7\u6838\u5bf9\u60a8\u7684\u6743\u9650");
            }
            String userId = request.getParameter("userId");
            if (!userId.matches("^[0-9]*$")) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u53c2\u6570\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty(userId)) {
                manufacturer.setUserid(userId);
                LOGGER.info("change manufacturer accout , oldAccout:" + account + ",newAccout:" + userId);
            }
            if (!(check = this.check(manufacturer)).equals("0")) {
                return check;
            }
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(manufacturer);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("AlterApply.do\u5f02\u5e38\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4fdd\u5b58\u6210\u529f");
    }
}

