/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.gift;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.json.JSONUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.dto.PackageWebgameGiftDTO;
import com.xunlei.niux.data.giftcenter.exception.PackageRuntimeException;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.data.giftcenter.vo.PackageGiftNumber;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import com.xunlei.niux.giftcenter.cmd.DefaultAbstractCmd;
import com.xunlei.niux.giftcenter.cmd.gift.GiftHandoutUtils;
import com.xunlei.niux.giftcenter.cmd.gift.GiftUtils;
import com.xunlei.niux.giftcenter.model.RtnMsg;
import com.xunlei.niux.giftcenter.task.AsyncExecutor;
import com.xunlei.niux.giftcenter.task.HandoutLogCaller;
import com.xunlei.niux.giftcenter.util.LogUtils;
import com.xunlei.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class WebGameGiftCmd
extends DefaultAbstractCmd {
    private static Logger logger = Log.getLogger(WebGameGiftCmd.class.getName());
    private static Logger pickupLog = Log.getLogger(LogUtils.getPickupLog());
    private static final String REDIS_KEY_PREFIX = "COM_XUNLEI_NIUX_GIFTCENTER_CMD_GIFT_WEBGAMEGIFTCMD_";

    @CmdMapper(value={"/gift/web/giftDetail.do"})
    public Object getWebGameGiftDetail(XLHttpRequest request, XLHttpResponse response) {
        try {
            long packageId = this.getPackageId(request);
            PackageWebgameGift pkg = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class, packageId);
            if (pkg == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u793c\u5305ID\u5f02\u5e38");
            }
            PackageGiftNumber query = new PackageGiftNumber();
            query.setPackageId(packageId);
            query.setGameType(1);
            PackageGiftNumber packageGiftNumber = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            PackageGames game = FacadeFactory.INSTANCE.getBaseSo().findById(PackageGames.class, pkg.getGameId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("packageId", pkg.getSeqid());
            map.put("gameId", pkg.getGameId());
            map.put("platformId", pkg.getPlatformId());
            map.put("packageName", pkg.getPackageName());
            map.put("packageContent", pkg.getPackageContent());
            map.put("activationTips", pkg.getActivationTips());
            map.put("gameUrl", pkg.getGameUrl());
            map.put("packageStatus", pkg.getPackageStatus());
            map.put("startTime", pkg.getStartTime());
            map.put("endTime", pkg.getEndTime());
            map.put("needXLVip", pkg.getNeedXLVip());
            map.put("needPhone", pkg.getNeedPhone());
            map.put("total", packageGiftNumber.getTotal());
            map.put("used", packageGiftNumber.getUsed());
            map.put("logo", game.getLogo());
            map.put("showStatus", GiftUtils.getShowStatus(pkg.getStartTime(), pkg.getEndTime(), packageGiftNumber.getTotal(), packageGiftNumber.getUsed()));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/web/giftList.do"})
    public Object getWebGameGiftList(XLHttpRequest request, XLHttpResponse response) {
        try {
            String queryType = request.getParameter("queryType");
            int pageNo = request.getParameterInteger("pageNo", 1);
            int pageSize = request.getParameterInteger("pageSize", 20);
            int cnt = FacadeFactory.INSTANCE.getXlGiftCenterBo().countPackageWebgameGift(queryType);
            ArrayList<PackageWebgameGiftDTO> list = new ArrayList();
            if (cnt > 0) {
                list = FacadeFactory.INSTANCE.getXlGiftCenterBo().getPackageWebgameGift(queryType, pageNo, pageSize);
            }
            HashMap<String, Object> object = new HashMap<String, Object>();
            object.put("rtn", 0);
            object.put("count", cnt);
            object.put("data", this.polishing(list));
            return JSONUtil.fromObject(object);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/web/releaseKey.do"})
    public Object releaseKey(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            long packageId = this.getPackageId(request);
            int gameType = this.getWebGameType();
            String lmtKy = "COM_XUNLEI_NIUX_GIFTCENTER_CMD_GIFT_WEBGAMEGIFTCMD_releaseKey_" + uid + "_limited_" + packageId + "_" + gameType;
            if (GiftUtils.limitedAccessTimes(lmtKy, 3, 5)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1000, "UNNORMAL");
            }
            logger.info("[RELEASE START] uid={}, packageId={}, gameType={}, id={}", new Object[]{uid, packageId, gameType, request.getRemoteIP()});
            RtnMsg rtnMsg = GiftHandoutUtils.checkWebRelease(WebGameGiftCmd.class.getName(), uid, packageId, gameType);
            if (rtnMsg.getRtn() != 0) {
                logger.error("[RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, rtnMsg.getMsg()});
                return JsonObjectUtil.getRtnAndDataJsonObject(rtnMsg.getRtn(), rtnMsg.getMsg());
            }
            PackageWebgameGiftKey giftKey = FacadeFactory.INSTANCE.getXlGiftCenterBo().releaseWebKey(uid, packageId);
            if (giftKey == null) {
                logger.error("[RELEASE ERROR] uid={}, packageId={}, gameType={}, msg=not found any key", new Object[]{uid, packageId, gameType});
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u9886\u53d6\u5931\u8d25");
            }
            FacadeFactory.INSTANCE.getGiftCenterBo().adjustPackageNumber(packageId, gameType);
            AsyncExecutor.getInstance().execute(new HandoutLogCaller(gameType, packageId, uid, giftKey.getGiftKey()));
            logger.error("[RELEASE DONE] uid={}, packageId={}, gameType={}, ip={}", new Object[]{uid, packageId, gameType, request.getRemoteIP()});
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("key", giftKey.getGiftKey());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (PackageRuntimeException e) {
            logger.error("PackageRuntimeException:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(98, e.getMessage());
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/web/pickupKey.do"})
    public Object pickupKey(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            long packageId = this.getPackageId(request);
            int gameType = this.getWebGameType();
            String lmtKy = "COM_XUNLEI_NIUX_GIFTCENTER_CMD_GIFT_WEBGAMEGIFTCMD_pickupKey_" + uid;
            if (GiftUtils.limitedAccessTimes(lmtKy, 60, 60)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "UNNORMAL");
            }
            pickupLog.info("[PICKUP START] uid={}, packageId={}, gameType={}, ip={}", new Object[]{uid, packageId, gameType, request.getRemoteIP()});
            RtnMsg rtnMsg = GiftHandoutUtils.checkWebPickup(LogUtils.getPickupLog(), uid, packageId, gameType);
            if (rtnMsg.getRtn() != 0) {
                pickupLog.error("[PICKUP ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, rtnMsg.getMsg()});
                return JsonObjectUtil.getRtnAndDataJsonObject(rtnMsg.getRtn(), rtnMsg.getMsg());
            }
            PackageWebgameGiftKey giftKey = FacadeFactory.INSTANCE.getXlGiftCenterBo().pickupWebKey(uid, packageId);
            if (giftKey == null) {
                pickupLog.error("[PICKUP ERROR] uid={}, packageId={}, gameType={}, msg=not found any key ", new Object[]{uid, packageId, gameType});
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u9886\u53d6\u5931\u8d25");
            }
            int times = GiftHandoutUtils.getPickupTimes(packageId, gameType);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("key", giftKey.getGiftKey());
            data.put("times", times);
            pickupLog.info("[PICKUP DONE] uid={}, packageId={}, gameType={}, key={}, times={}, ip={}", new Object[]{uid, packageId, gameType, giftKey.getGiftKey(), times, request.getRemoteIP()});
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (PackageRuntimeException e) {
            pickupLog.error("PackageRuntimeException:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(98, e.getMessage());
        }
        catch (Exception e) {
            pickupLog.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private List<Map<String, Object>> polishing(List<PackageWebgameGiftDTO> dtoList) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (PackageWebgameGiftDTO dto : dtoList) {
            Map map = BeanUtils.describe(dto);
            map.put("showStatus", GiftUtils.getShowStatus(dto.getStartTime(), dto.getEndTime(), dto.getTotal(), dto.getUsed()));
            list.add(map);
        }
        return list;
    }
}

