/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.gift;

import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.giftcenter.proxy.JRedisProxy;
import org.apache.commons.lang.StringUtils;

public class GiftUtils {
    public static int getShowStatus(String startTime, String endTime, int total, int used) {
        if (StringUtils.isEmpty(startTime) || StringUtils.isEmpty(endTime) || total == 0) {
            return -1;
        }
        String now = DateUtil.formatNowByDefault();
        if (DateUtil.compareTime(now, startTime) < 0L) {
            return 1;
        }
        if (DateUtil.compareTime(now, endTime) > 0L) {
            return 2;
        }
        if (total == used) {
            return 3;
        }
        return 0;
    }

    public static boolean limitedAccessTimes(String keySrc, int expireSecond, int limitedTimes) {
        String key = keySrc.toUpperCase();
        return GiftUtils.incrAndRtnKeyTimes(key, expireSecond) > limitedTimes;
    }

    private static int incrAndRtnKeyTimes(String key, int expire) {
        JRedisProxy redis = JRedisProxy.getInstance();
        redis.incr(key, expire);
        return Integer.valueOf(redis.get(key));
    }
}

