/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackagePickupNumber;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.giftcenter.model.RtnMsg;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_score;
import com.xunlei.util.Log;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class GiftHandoutUtils {
    public static RtnMsg checkWebRelease(String logName, long uid, long packageId, int gameType) {
        Logger logger = Log.getLogger(logName);
        PackageWebgameGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class, packageId);
        if (gift == null) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getPackageStatus() != 1) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, packageStatus={}, msg={}", new Object[]{uid, packageId, gameType, gift.getPackageStatus(), msg});
            return new RtnMsg(10, msg);
        }
        if (GiftHandoutUtils.badTime(gift.getStartTime(), gift.getEndTime())) {
            String msg = "\u9886\u53d6\u793c\u5305\u65f6\u95f4\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, startTime={}, endTime={}, msg={}", new Object[]{uid, packageId, gameType, gift.getStartTime(), gift.getEndTime(), msg});
            return new RtnMsg(10, msg);
        }
        if (!FacadeFactory.INSTANCE.getXlGiftCenterBo().hasGiftNum(packageId, gameType)) {
            String msg = "\u65e0\u5269\u4f59\u793c\u5305";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (FacadeFactory.INSTANCE.getXlGiftCenterBo().hasUserGiftRecord(uid, packageId, gameType)) {
            String msg = "\u5df2\u9886\u53d6\u8be5\u793c\u5305";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getNeedPhone() != null && gift.getNeedPhone() == 1 && !GiftHandoutUtils.isBindPhone(uid + "")) {
            String msg = "\u672a\u7ed1\u5b9a\u624b\u673a";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1001, msg);
        }
        if (gift.getNeedXLVip() != null && gift.getNeedXLVip() == 1 && !GiftHandoutUtils.isXunleiVIP(uid + "")) {
            String msg = "\u975e\u8fc5\u96f7\u4f1a\u5458";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1002, msg);
        }
        return new RtnMsg();
    }

    public static RtnMsg checkWebPickup(String logName, Long uid, Long packageId, Integer gameType) {
        Logger pickupLog = Log.getLogger(logName);
        PackageWebgameGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class, packageId);
        if (gift == null) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getPackageStatus() != 1) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, packageStatus={}, msg={}", new Object[]{uid, packageId, gameType, gift.getPackageStatus(), msg});
            return new RtnMsg(10, msg);
        }
        if (GiftHandoutUtils.badTime(gift.getStartTime(), gift.getEndTime())) {
            String msg = "\u9886\u53d6\u793c\u5305\u65f6\u95f4\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, startTime={}, endTime={}, msg={}", new Object[]{uid, packageId, gameType, gift.getStartTime(), gift.getEndTime(), msg});
            return new RtnMsg(10, msg);
        }
        if (FacadeFactory.INSTANCE.getXlGiftCenterBo().hasGiftNum(packageId, gameType)) {
            String msg = "\u672a\u8fdb\u5165\u6dd8\u53f7\u72b6\u6001";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getNeedPhone() != null && gift.getNeedPhone() == 1 && !GiftHandoutUtils.isBindPhone(uid + "")) {
            String msg = "\u672a\u7ed1\u5b9a\u624b\u673a";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1001, msg);
        }
        if (gift.getNeedXLVip() != null && gift.getNeedXLVip() == 1 && !GiftHandoutUtils.isXunleiVIP(uid + "")) {
            String msg = "\u975e\u8fc5\u96f7\u4f1a\u5458";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1002, msg);
        }
        return new RtnMsg();
    }

    public static RtnMsg checkMobileRelease(String logName, long uid, long packageId, int gameType) {
        Logger logger = Log.getLogger(logName);
        PackageMobilegameGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobilegameGift.class, packageId);
        if (gift == null) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getPackageStatus() != 1) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, packageStatus={}, msg={}", new Object[]{uid, packageId, gameType, gift.getPackageStatus(), msg});
            return new RtnMsg(10, msg);
        }
        if (GiftHandoutUtils.badTime(gift.getStartTime(), gift.getEndTime())) {
            String msg = "\u9886\u53d6\u793c\u5305\u65f6\u95f4\u9519\u8bef";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, startTime={}, endTime={}, msg={}", new Object[]{uid, packageId, gameType, gift.getStartTime(), gift.getEndTime(), msg});
            return new RtnMsg(10, msg);
        }
        if (!FacadeFactory.INSTANCE.getXlGiftCenterBo().hasGiftNum(packageId, gameType)) {
            String msg = "\u65e0\u5269\u4f59\u793c\u5305";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (FacadeFactory.INSTANCE.getXlGiftCenterBo().hasUserGiftRecord(uid, packageId, gameType)) {
            String msg = "\u5df2\u9886\u53d6\u8be5\u793c\u5305";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getNeedPhone() != null && gift.getNeedPhone() == 1 && !GiftHandoutUtils.isBindPhone(uid + "")) {
            String msg = "\u672a\u7ed1\u5b9a\u624b\u673a";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1001, msg);
        }
        if (gift.getNeedXLVip() != null && gift.getNeedXLVip() == 1 && !GiftHandoutUtils.isXunleiVIP(uid + "")) {
            String msg = "\u975e\u8fc5\u96f7\u4f1a\u5458";
            logger.error("[CHECK RELEASE ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1002, msg);
        }
        return new RtnMsg();
    }

    public static RtnMsg checkMobilePickup(String logName, Long uid, Long packageId, Integer gameType) {
        Logger pickupLog = Log.getLogger(logName);
        PackageMobilegameGift gift = FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobilegameGift.class, packageId);
        if (gift == null) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getPackageStatus() != 1) {
            String msg = "\u9886\u53d6\u793c\u5305\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, packageStatus={}, msg={}", new Object[]{uid, packageId, gameType, gift.getPackageStatus(), msg});
            return new RtnMsg(10, msg);
        }
        if (GiftHandoutUtils.badTime(gift.getStartTime(), gift.getEndTime())) {
            String msg = "\u9886\u53d6\u793c\u5305\u65f6\u95f4\u9519\u8bef";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, packageId={}, gameType={}, startTime={}, endTime={}, msg={}", new Object[]{uid, packageId, gameType, gift.getStartTime(), gift.getEndTime(), msg});
            return new RtnMsg(10, msg);
        }
        if (FacadeFactory.INSTANCE.getXlGiftCenterBo().hasGiftNum(packageId, gameType)) {
            String msg = "\u672a\u8fdb\u5165\u6dd8\u53f7\u72b6\u6001";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(10, msg);
        }
        if (gift.getNeedPhone() != null && gift.getNeedPhone() == 1 && !GiftHandoutUtils.isBindPhone(uid + "")) {
            String msg = "\u672a\u7ed1\u5b9a\u624b\u673a";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1001, msg);
        }
        if (gift.getNeedXLVip() != null && gift.getNeedXLVip() == 1 && !GiftHandoutUtils.isXunleiVIP(uid + "")) {
            String msg = "\u975e\u8fc5\u96f7\u4f1a\u5458";
            pickupLog.error("[CHECK PICKUP ERROR] uid={}, pickup packageId={}, gameType={}, msg={}", new Object[]{uid, packageId, gameType, msg});
            return new RtnMsg(1002, msg);
        }
        return new RtnMsg();
    }

    public static int getPickupTimes(long packageId, int gameType) {
        PackagePickupNumber num = new PackagePickupNumber();
        num.setPackageId(packageId);
        num.setGameType(gameType);
        PackagePickupNumber packagePickupNumber = FacadeFactory.INSTANCE.getBaseSo().findObject(num);
        int times = 0;
        if (packagePickupNumber != null) {
            times = packagePickupNumber.getTimes();
        }
        return times;
    }

    public static boolean isBindPhone(String userid) {
        CustomerInfo info = new CustomerInfo();
        info.setUid(userid);
        List<CustomerInfo> infolist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
        return infolist != null && infolist.size() > 0 && infolist.get(0) != null && StringUtils.isNotEmpty(infolist.get(0).getPhone());
    }

    public static boolean isXunleiVIP(String uid) {
        Resp_getuserinfo_score info = ProxyFactory.getInstance().getUserInfoProxy().getuserinfo_score(uid, (byte)2);
        return info.getIsuservip() == 1;
    }

    private static boolean badTime(String startTime, String endTime) {
        String now = DateUtil.formatNowByDefault();
        return DateUtil.compareTime(now, startTime) < 0L || DateUtil.compareTime(now, endTime) > 0L;
    }
}

