/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.giftcenter.cmd.gift;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.giftcenter.dto.SearchPackageDTO;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.BookingGiftRecord;
import com.xunlei.niux.giftcenter.cmd.DefaultAbstractCmd;
import com.xunlei.niux.giftcenter.cmd.gift.GiftUtils;
import com.xunlei.niux.giftcenter.proxy.JRedisProxy;
import com.xunlei.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GiftCmd
extends DefaultAbstractCmd {
    private static final long CACHE_TIME = 300000L;
    private AtomicLong lastUpdateCacheTime = new AtomicLong(0L);
    private static final String REDIS_KEY_PREFIX = "COM_XUNLEI_NIUX_GIFTCENTER_CMD_GIFT_GIFTCMD_";
    private static Logger logger = Log.getLogger(GiftCmd.class.getName());

    @CmdMapper(value={"/gift/search.do"})
    public Object search(XLHttpRequest request, XLHttpResponse response) {
        try {
            String keyword = request.getParameter("keyword");
            if (StringUtils.isEmpty(keyword)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            keyword = keyword.trim();
            HashSet<String> sensitiveSet = new HashSet<String>();
            sensitiveSet.add("=");
            sensitiveSet.add(";");
            sensitiveSet.add("\"");
            sensitiveSet.add("<");
            sensitiveSet.add(">");
            sensitiveSet.add("and");
            sensitiveSet.add("or");
            sensitiveSet.add(",");
            sensitiveSet.add("select");
            sensitiveSet.add("insert");
            sensitiveSet.add("update");
            sensitiveSet.add("delete");
            sensitiveSet.add("exec");
            sensitiveSet.add("@");
            sensitiveSet.add(".");
            for (String sen : sensitiveSet) {
                if (!keyword.contains(sen)) continue;
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u975e\u6cd5\u5b57\u7b26");
            }
            List<SearchPackageDTO> list = FacadeFactory.INSTANCE.getXlGiftCenterBo().searchGift(keyword);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, this.polishing(list));
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/booking.do"})
    public Object booking(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            String pacakgeIdStr = request.getParameter("packageId");
            String gameTypeStr = request.getParameter("gameType");
            if (StringUtils.isEmpty(pacakgeIdStr) || StringUtils.isEmpty(gameTypeStr)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            Long packageId = Long.valueOf(pacakgeIdStr);
            Integer gameType = Integer.valueOf(gameTypeStr);
            if (gameType != 1 && gameType != 2) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u6e38\u620f\u7c7b\u578b\u9519\u8bef");
            }
            Map<String, Object> bookMap = FacadeFactory.INSTANCE.getIndexPageBo().getBookingGift();
            if (bookMap == null || bookMap.size() == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u6539\u793c\u5305\u65e0\u6cd5\u9884\u8ba2");
            }
            String bookPackageId = bookMap.get("packageId").toString();
            String bookGameType = bookMap.get("gameType").toString();
            if (!pacakgeIdStr.equals(bookPackageId) || !gameTypeStr.equals(bookGameType)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u6539\u793c\u5305\u65e0\u6cd5\u9884\u8ba2");
            }
            BookingGiftRecord queryBook = new BookingGiftRecord();
            queryBook.setUid(uid);
            queryBook.setPackageId(packageId);
            queryBook.setGameType(gameType);
            if (FacadeFactory.INSTANCE.getBaseSo().countObject(queryBook) > 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u91cd\u590d\u9884\u8ba2\u793c\u5305");
            }
            FacadeFactory.INSTANCE.getXlGiftCenterBo().addBookingGiftRecord(uid, packageId, gameType);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/bookingHint.do"})
    public Object bookingHint(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            this.checkCache();
            String record = JRedisProxy.getInstance().get(REDIS_KEY_PREFIX + uid);
            if (StringUtils.isNotEmpty(record)) {
                return JsonObjectUtil.getOnlyRtnJson(1);
            }
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gift/bookingCancel.do"})
    public Object bookingCancel(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            String pacakgeIdStr = request.getParameter("packageId");
            String gameTypeStr = request.getParameter("gameType");
            if (StringUtils.isEmpty(pacakgeIdStr) || StringUtils.isEmpty(gameTypeStr)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            Long packageId = Long.valueOf(pacakgeIdStr);
            Integer gameType = Integer.valueOf(gameTypeStr);
            if (gameType != 1 && gameType != 2) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u6e38\u620f\u7c7b\u578b\u9519\u8bef");
            }
            BookingGiftRecord query = new BookingGiftRecord();
            query.setPackageId(packageId);
            query.setGameType(gameType);
            query.setUid(uid);
            query.setExpired(0);
            BookingGiftRecord record = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (record == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u6ca1\u6709\u9884\u5b9a\u8be5\u793c\u5305");
            }
            FacadeFactory.INSTANCE.getBaseSo().deleteById(BookingGiftRecord.class, record.getSeqid());
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public List<Map<String, Object>> polishing(List<SearchPackageDTO> dtoList) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (SearchPackageDTO dto : dtoList) {
            Map map = BeanUtils.describe(dto);
            map.put("showStatus", GiftUtils.getShowStatus(dto.getStartTime(), dto.getEndTime(), dto.getTotal(), dto.getUsed()));
            list.add(map);
        }
        return list;
    }

    private void checkCache() {
        long cur = System.currentTimeMillis();
        long nextUpdateCacheTimes = this.lastUpdateCacheTime.get() + 300000L;
        if (nextUpdateCacheTimes < cur) {
            this.updateBookingCache();
            this.lastUpdateCacheTime.set(cur);
        }
    }

    private synchronized void updateBookingCache() {
        FacadeFactory.INSTANCE.getBookingBo().expired();
        List<BookingGiftRecord> list = FacadeFactory.INSTANCE.getBookingBo().getAllBooking();
        HashMap<String, String> map = new HashMap<String, String>();
        for (BookingGiftRecord record : list) {
            map.put(REDIS_KEY_PREFIX + record.getUid(), record.getPackageId() + "-" + record.getGameType());
        }
        JRedisProxy.getInstance().setByPipeline(map, 300);
    }
}

