/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.easyutils.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HtmlUtil {
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_html = "<[^>]+>";
    private static final String regEx_space = "\\s*|\t|\r|\n";

    public static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        return htmlStr.trim();
    }

    public static String getTextFromHtml(String htmlStr) {
        htmlStr = HtmlUtil.delHTMLTag(htmlStr);
        htmlStr = htmlStr.replaceAll("&nbsp;", "");
        htmlStr = htmlStr.substring(0, htmlStr.indexOf("\u3002") + 1);
        return htmlStr;
    }

    public static String vagueString(String str) {
        if (StringUtils.isEmpty(str)) {
            return "***";
        }
        int len = str.length();
        if (len < 3) {
            return "***";
        }
        if (len >= 3 && len < 5) {
            return String.valueOf(str.substring(0, 1)) + "***";
        }
        return String.valueOf(str.substring(0, 2)) + "***" + str.substring(len - 2, len);
    }

    public static void main(String[] args) {
        String str = "<div style='text-align:center;'>&nbsp;\u6574\u6cbb\u201c\u56db\u98ce\u201d&nbsp;&nbsp;&nbsp;\u6e05\u5f0a\u9664\u57a2<br/><span style='font-size:14px;'>&nbsp;</span><span style='font-size:18px;'>\u516c\u53f8\u53ec\u5f00\u515a\u7684\u7fa4\u4f17\u8def\u7ebf\u6559\u80b2\u5b9e\u8df5\u6d3b\u52a8\u52a8\u5458\u5927\u4f1a</span><br/></div>";
        System.out.println(HtmlUtil.getTextFromHtml(str));
    }
}

