/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.lottery;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.lottery.FortuneGiftDao;
import com.xunlei.niux.data.vipgame.vo.FortuneGift;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class FortuneGiftDaoImpl
extends BaseDaoImpl
implements FortuneGiftDao {
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public List<FortuneGift> getValidFortuneGifts(Date date, int size) {
        final ArrayList<FortuneGift> resultList = new ArrayList<FortuneGift>();
        if (date == null || size <= 0) {
            return resultList;
        }
        String sql = "SELECT fortunegift.fortuneGiftId,fortunegift.fortuneGiftLotId,fortunegift.giftId,fortunegift.giftPic,fortunegift.fortunePoint,fortunegift.isValid,fortunegift.inputBy,fortunegift.inputTime,fortunegift.editBy,fortunegift.editTime FROM fortunegift JOIN \n(SELECT * FROM fortunegiftlot \nWHERE beginTime < ? AND endTime > ? AND isValid = 1\nORDER BY fortuneGiftLotId DESC\nLIMIT 1) AS fortunegiftlot ON fortunegift.fortuneGiftLotId = fortunegiftlot.fortuneGiftLotId\nWHERE fortunegift.isValid = 1\nORDER BY fortunegift.fortunePoint \nLIMIT ?";
        String curTime = sdf_time.format(date);
        Object[] args = new Object[]{curTime, curTime, size};
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                FortuneGift fortuneGift = new FortuneGift();
                fortuneGift.setFortuneGiftId(Long.parseLong(resultSet.getString(1)));
                fortuneGift.setFortuneGiftLotId(Long.parseLong(resultSet.getString(2)));
                fortuneGift.setGiftId(Long.parseLong(resultSet.getString(3)));
                fortuneGift.setGiftPic(resultSet.getString(4));
                fortuneGift.setFortunePoint(Integer.parseInt(resultSet.getString(5)));
                fortuneGift.setIsValid(Boolean.valueOf(resultSet.getString(6)));
                fortuneGift.setInputBy(resultSet.getString(7));
                fortuneGift.setInputTime(resultSet.getString(8));
                fortuneGift.setEditBy(resultSet.getString(9));
                fortuneGift.setEditTime(resultSet.getString(10));
                resultList.add(fortuneGift);
            }
        });
        return resultList;
    }
}

