/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.bonus;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.bo.bonus.BonusProductGiveOutDayStatisticsBo;
import com.xunlei.niux.data.vipgame.bo.bonus.ExchangeTransBo;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.bt.bonus.ExchangeTransBt;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.ExchangeTrans;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeTransBoImpl
implements ExchangeTransBo {
    private static SimpleDateFormat sdfShort = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private BonusProductBo bonusProductBo;
    @Autowired
    private BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo;

    @Override
    public ExchangeTrans insert(ExchangeTrans pTrans) {
        Date now = new Date();
        BonusProduct bonusProduct = this.bonusProductBo.update_consume(pTrans.getProductNo());
        ExchangeTrans latestExchangeTrans = this.checkUserExchanged(pTrans.getUserId(), bonusProduct);
        if (latestExchangeTrans != null) {
            this.bonusProductBo.update_rechargefailconsum(pTrans.getProductNo());
            return latestExchangeTrans;
        }
        BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdfShort.format(now), bonusProduct.getEverydayMaxNum());
        this.bonusProductGiveOutDayStatisticsBo.update_addOne(bonusProduct.getProductNo(), sdfShort.format(now));
        ExchangeTrans exchangeTrans = new ExchangeTrans();
        exchangeTrans.setBalanceDate(sdfShort.format(now));
        exchangeTrans.setBonusConsumeStatus("0");
        exchangeTrans.setBonusConsumeTime("");
        exchangeTrans.setBonusNum(pTrans.getBonusNum());
        exchangeTrans.setExchangeDirect(bonusProduct.getExchangeType());
        exchangeTrans.setExchangeStatus("0");
        exchangeTrans.setExchangeTime(sdf.format(now));
        exchangeTrans.setGameId(bonusProduct.getGameId());
        exchangeTrans.setProductLot(bonusProduct.getProductLot());
        exchangeTrans.setProductName(bonusProduct.getProductName());
        exchangeTrans.setProductNo(bonusProduct.getProductNo());
        exchangeTrans.setProductType(bonusProduct.getProductType());
        exchangeTrans.setProductUnit(bonusProduct.getProductUnit());
        exchangeTrans.setProductNum(pTrans.getProductNum());
        exchangeTrans.setRemark(pTrans.getRemark());
        exchangeTrans.setSerialNumber("");
        exchangeTrans.setServerId(pTrans.getServerId());
        exchangeTrans.setUserId(pTrans.getUserId());
        exchangeTrans.setUserName(pTrans.getUserName());
        exchangeTrans.setExchangeNo(OrderNoUtil.getOrderNo());
        exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
        ExchangeTransBt.checkInsertParam(exchangeTrans);
        this.baseDao.insert(exchangeTrans);
        return exchangeTrans;
    }

    @Override
    public ExchangeTrans checkUserExchanged(String userId, BonusProduct pBonusProduct) {
        ExchangeTrans latestExchangeTrans = this.checkUserExceedEveryDayExchangeNum(userId, pBonusProduct);
        if (latestExchangeTrans != null) {
            return latestExchangeTrans;
        }
        return this.checkUserExceedRestrictExchangeNum(userId, pBonusProduct);
    }

    private ExchangeTrans checkUserExceedEveryDayExchangeNum(String userId, BonusProduct pBonusProduct) {
        if (pBonusProduct.getUserEverydayMaxNum() == null || pBonusProduct.getUserEverydayMaxNum() <= 0) {
            return null;
        }
        Date now = new Date();
        ExchangeTrans query = new ExchangeTrans();
        query.setUserId(userId);
        query.setProductNo(pBonusProduct.getProductNo());
        query.setToExchangeStatus("3");
        query.setBalanceDate(sdfShort.format(now));
        int count = this.baseDao.count(query);
        if (count < pBonusProduct.getUserEverydayMaxNum()) {
            return null;
        }
        Page page = new Page();
        page.addOrder("exchangeTime", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        return this.findOne(query, page);
    }

    private ExchangeTrans checkUserExceedRestrictExchangeNum(String userId, BonusProduct pBonusProduct) {
        int count;
        if (pBonusProduct.getUserRestrictMaxNum() == null || pBonusProduct.getUserRestrictMaxNum() <= 0) {
            return null;
        }
        Date now = new Date();
        Date restrictDate = null;
        if (pBonusProduct.getRestrictDays() != null && pBonusProduct.getRestrictDays() > 0) {
            restrictDate = new Date(now.getTime() - (long)(86400000 * (pBonusProduct.getRestrictDays() - 1)));
        }
        ExchangeTrans query = new ExchangeTrans();
        query.setUserId(userId);
        query.setProductNo(pBonusProduct.getProductNo());
        query.setToExchangeStatus("3");
        if (restrictDate != null) {
            query.setFromBalanceDate(sdfShort.format(restrictDate));
        }
        if ((count = this.baseDao.count(query)) < pBonusProduct.getUserRestrictMaxNum()) {
            return null;
        }
        Page page = new Page();
        page.addOrder("exchangeTime", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        return this.findOne(query, page);
    }

    @Override
    public ExchangeTrans updateBonusConsumeStatus(ExchangeTrans pTrans, boolean isSuccess) {
        ExchangeTrans exchangeTrans = this.find(pTrans.getExchangeNo());
        if (exchangeTrans == null) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u4e0d\u5b58\u5728");
        }
        if (!"0".equals(exchangeTrans.getExchangeStatus())) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + exchangeTrans.getExchangeNo() + "]\u4e0d\u5b58\u4e8e\u79ef\u5206\u6263\u9664\u9636\u6bb5");
        }
        if (!isSuccess) {
            this.bonusProductBo.update_rechargefailconsum(exchangeTrans.getProductNo());
            this.bonusProductGiveOutDayStatisticsBo.update_removeOne(exchangeTrans.getProductNo(), exchangeTrans.getBalanceDate());
        }
        Date now = new Date();
        exchangeTrans.setBonusConsumeTime(sdf.format(now));
        exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
        exchangeTrans.setRemark(pTrans.getRemark());
        if (isSuccess) {
            exchangeTrans.setExchangeStatus("1");
            exchangeTrans.setBonusConsumeStatus("1");
        } else {
            exchangeTrans.setExchangeStatus("3");
            exchangeTrans.setBonusConsumeStatus("2");
        }
        this.baseDao.updateById(exchangeTrans);
        return exchangeTrans;
    }

    @Override
    public ExchangeTrans updateProductGiveOutStatus(ExchangeTrans pTrans, boolean isSuccess) {
        ExchangeTrans exchangeTrans = this.find(pTrans.getExchangeNo());
        if (exchangeTrans == null) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(exchangeTrans.getExchangeStatus())) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + exchangeTrans.getExchangeNo() + "]\u4e0d\u5904\u4e8e\u53d1\u653e\u5956\u54c1\u9636\u6bb5");
        }
        if (!isSuccess) {
            this.bonusProductBo.update_rechargefailconsum(exchangeTrans.getProductNo());
            this.bonusProductGiveOutDayStatisticsBo.update_removeOne(exchangeTrans.getProductNo(), exchangeTrans.getBalanceDate());
        }
        Date now = new Date();
        exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
        exchangeTrans.setRemark(pTrans.getRemark());
        if (isSuccess) {
            exchangeTrans.setSerialNumber(pTrans.getSerialNumber());
            exchangeTrans.setExchangeStatus("2");
        } else {
            exchangeTrans.setExchangeStatus("4");
        }
        this.baseDao.updateById(exchangeTrans);
        return exchangeTrans;
    }

    @Override
    public ExchangeTrans updateBonusReturnSuccess(ExchangeTrans pTrans) {
        ExchangeTrans exchangeTrans = this.find(pTrans.getExchangeNo());
        if (exchangeTrans == null) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u4e0d\u5b58\u5728");
        }
        if (!"4".equals(exchangeTrans.getExchangeStatus())) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + exchangeTrans.getExchangeNo() + "]\u4e0d\u5904\u4e8e\u9000\u56de\u79ef\u5206\u9636\u6bb5");
        }
        if (!"1".equals(exchangeTrans.getBonusConsumeStatus())) {
            throw new RuntimeException("\u5151\u6362\u8ba2\u5355[" + exchangeTrans.getExchangeNo() + "]\u672a\u6210\u529f\u6263\u9664\u79ef\u5206");
        }
        Date now = new Date();
        exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
        exchangeTrans.setRemark(pTrans.getRemark());
        exchangeTrans.setExchangeStatus("3");
        exchangeTrans.setBonusConsumeStatus("3");
        this.baseDao.updateById(exchangeTrans);
        return exchangeTrans;
    }

    @Override
    public List<ExchangeTrans> find(ExchangeTrans pTrans, Page page) {
        return this.baseDao.findByObject(ExchangeTrans.class, pTrans, page);
    }

    @Override
    public ExchangeTrans findOne(ExchangeTrans pTrans, Page page) {
        List<ExchangeTrans> list = this.find(pTrans, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public ExchangeTrans find(String exchangeNo) {
        if (exchangeNo == null || "".equals(exchangeNo)) {
            throw new RuntimeException("\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a");
        }
        ExchangeTrans query = new ExchangeTrans();
        query.setExchangeNo(exchangeNo);
        return this.findOne(query, new Page());
    }

    @Override
    public int count(ExchangeTrans pTrans) {
        return this.baseDao.count(pTrans);
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public BonusProductBo getBonusProductBo() {
        return this.bonusProductBo;
    }

    public void setBonusProductBo(BonusProductBo bonusProductBo) {
        this.bonusProductBo = bonusProductBo;
    }
}

