/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.niux.data.vipgame.bo.SpreadinfoBo;
import com.xunlei.niux.data.vipgame.vo.Flatno;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import java.util.List;

public class SpreadinfoBoImpl
implements SpreadinfoBo {
    private BaseDao baseDao;

    @Override
    public int count(Spreadinfo spreadinfo) {
        return this.baseDao.count(spreadinfo);
    }

    @Override
    public List<Flatno> findFlatnoList() {
        return this.baseDao.findBySql(Flatno.class, "SELECT DISTINCT flatno FROM spreadinfo");
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void insertSpreadInfo(Spreadinfo spreadInfo) {
        this.checkAdvNo(spreadInfo);
        this.baseDao.insert(spreadInfo);
    }

    private void checkAdvNo(Spreadinfo spreadInfo) {
        String advNoStr;
        String jumpurl = spreadInfo.getJumpurl();
        if (!jumpurl.contains(advNoStr = "advNo=" + spreadInfo.getAdvNo())) {
            jumpurl = jumpurl.endsWith("/") ? jumpurl + "?" + advNoStr : (jumpurl.endsWith("?") ? jumpurl + advNoStr : (!jumpurl.contains("?") ? jumpurl + "?" + advNoStr : jumpurl + "&" + advNoStr));
            spreadInfo.setJumpurl(jumpurl);
        }
    }

    @Override
    public void deleteSpreadInfo(Spreadinfo spreadinfo) {
        this.baseDao.deleteById(Spreadinfo.class, spreadinfo.getSeqId());
    }

    @Override
    public Spreadinfo findSpreadInfo(Spreadinfo spreadinfo) {
        Page p = new Page();
        p.addOrder("flatno", OrderType.DESC);
        List<Spreadinfo> list = this.baseDao.findByObject(Spreadinfo.class, spreadinfo, p);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Spreadinfo findSpreadInfo(long seqid) {
        return this.baseDao.findById(Spreadinfo.class, seqid);
    }

    @Override
    public List<Spreadinfo> findSpreadInfoInlist(Spreadinfo spreadinfo, PagedFliper fliper) {
        Page page = new Page();
        page.addOrder("flatno", OrderType.DESC);
        page.addOrder("spreadTab", OrderType.DESC);
        page.addOrder("advNo", OrderType.DESC);
        page.setPageNo(fliper.getPageNo());
        page.setPageSize(fliper.getPageSize());
        return this.baseDao.findByObject(Spreadinfo.class, spreadinfo, page);
    }

    @Override
    public void updateSpreadinfo(Spreadinfo spreadinfo) {
        this.checkAdvNo(spreadinfo);
        this.baseDao.updateById(spreadinfo);
    }

    @Override
    public void deleteSpreadInfoById(long seqId) {
        this.baseDao.deleteById(Spreadinfo.class, seqId);
    }
}

