/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.GamesBo;
import com.xunlei.niux.data.vipgame.dao.games.GamesDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.KuaiWanGameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.data.vipgame.vo.Games;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GamesBoImpl
implements GamesBo {
    private static final int GAMEIDCOUNT = 6;
    private GamesDao gamesDao;
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public GamesDao getGamesDao() {
        return this.gamesDao;
    }

    public void setGamesDao(GamesDao gamesDao) {
        this.gamesDao = gamesDao;
    }

    @Override
    public List<Games> findGames(Games games, int pageno, int limit) {
        Page page = new Page();
        page.setPageNo(pageno);
        page.setPageSize(limit);
        page.addOrder("displayOrder", OrderType.DESC);
        return this.gamesDao.findByObject(Games.class, games, page);
    }

    @Override
    public List<Games> findGames(Games games, Page page) {
        return this.gamesDao.findByObject(Games.class, games, page);
    }

    @Override
    public Games getGameByGameId(String gameId) {
        if (gameId == null || "".equals(gameId)) {
            return null;
        }
        Games game = new Games();
        game.setGameId(gameId);
        List<Games> list = this.gamesDao.findByObject(Games.class, game, new Page());
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public int count(Games games) {
        return this.gamesDao.count(games);
    }

    @Override
    public Games findGamesById(long seqId) {
        return this.gamesDao.findById(Games.class, seqId);
    }

    @Override
    public void insertGames(Games games) {
        this.gamesDao.insert(games);
    }

    @Override
    public void updateGames(Games games) {
        this.gamesDao.updateById(games);
    }

    @Override
    public List<GameDTO> queryGamesByKeyWord(String keyWord, int gameType) {
        if (gameType == 1) {
            return this.gamesDao.queryAppGamesByKeyWord(keyWord);
        }
        return this.gamesDao.queryWebGamesByKeyWord(keyWord);
    }

    @Override
    public List<GameDTO> getAllValidWebGames() {
        return this.gamesDao.getAllValidWebGames();
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        return this.gamesDao.getAllValidAppGames();
    }

    @Override
    public List<Games> queryGames(String keyWord, int limit) {
        return this.gamesDao.queryGames(keyWord, limit);
    }

    @Override
    public Games getCurrentNewstMobileGame() {
        return this.gamesDao.getCurrentNewstMobileGame();
    }

    @Override
    public List<MobileGameDTO> getAllMobileGames() {
        return this.gamesDao.getAllMobileGames();
    }

    @Override
    public String getNextNewCpsgameId() {
        long gameId = this.getMaxIntGameId() + 1L;
        String id = String.valueOf(gameId);
        int i = id.length();
        String baseId = this.getBaseId(6 - i);
        return baseId + id;
    }

    @Override
    public List<KuaiWanGameDTO> getKuaiwanWebGames() {
        return this.gamesDao.getKuaiwanWebGames();
    }

    @Override
    public List<KuaiWanGameDTO> getKuaiwanAppGames() {
        return this.gamesDao.getKuaiwanAppGames();
    }

    private String getBaseId(int i) {
        StringBuffer sb = new StringBuffer("");
        for (int j = 0; j < i; ++j) {
            sb.append("0");
        }
        return sb.toString();
    }

    private synchronized long getMaxIntGameId() {
        String gameId = this.getMaxGameId();
        return this.getId(gameId);
    }

    private String getMaxGameId() {
        CpsGames query = new CpsGames();
        Page page = new Page();
        page.addOrder("gameId", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List<CpsGames> gamesList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(gamesList)) {
            return "c000001";
        }
        return gamesList.get(0).getGameId();
    }

    private Long getId(String gameId) {
        gameId = gameId.substring(1);
        for (int i = gameId.length() - 1; i > 0; --i) {
            if (gameId.indexOf(this.getBaseId(i)) == -1) continue;
            gameId = gameId.substring(this.getBaseId(i).length() - 1);
            return Long.parseLong(gameId);
        }
        return 0L;
    }
}

