/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.giftcenter.dao.UserDao;
import com.xunlei.niux.data.giftcenter.dto.SearchPackageDTO;
import com.xunlei.niux.data.giftcenter.dto.UserGiftRecordDTO;
import com.xunlei.niux.data.giftcenter.util.KeyIndexUtils;
import com.xunlei.niux.data.giftcenter.vo.UserGiftRecord;
import java.util.ArrayList;
import java.util.List;

public class UserDaoImpl
extends BaseDaoImpl
implements UserDao {
    @Override
    public boolean isNotExistsUserTable(Long uid) {
        String table = "user_gift_record_" + KeyIndexUtils.getUserTableIndex(uid);
        String sql = "SELECT COUNT(1) FROM information_schema.tables WHERE table_name=?";
        int cnt = this.getJdbcTemplate().queryForInt(sql, new String[]{table});
        return cnt == 0;
    }

    @Override
    public void createUserTable(Long uid) {
        int index = KeyIndexUtils.getUserTableIndex(uid);
        String sql = " CREATE TABLE user_gift_record_" + index + " (\n" + "  seqid BIGINT(20) NOT NULL AUTO_INCREMENT,\n" + "  uid BIGINT(20) NOT NULL,\n" + "  recordTime VARCHAR(19) NOT NULL,\n" + "  giftKey VARCHAR(100) NOT NULL,\n" + "  platformId BIGINT(20) NOT NULL,\n" + "  gameId BIGINT(20) NOT NULL,\n" + "  gameType TINYINT(1) NOT NULL,\n" + "  packageId BIGINT(20) NOT NULL,\n" + "  PRIMARY KEY (seqid),\n" + "  KEY uid (uid)\n" + ") ENGINE=INNODB DEFAULT CHARSET=utf8 ";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void insertUserTable(UserGiftRecord record) {
        long uid = record.getUid();
        if (this.isNotExistsUserTable(uid)) {
            this.createUserTable(uid);
        }
        int index = KeyIndexUtils.getUserTableIndex(uid);
        String sql = " INSERT INTO user_gift_record_" + index + " (uid,recordTime,giftKey,platformId,gameId,gameType,packageId) VALUES ( ?,?,?,?,?,?,?);  ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(record.getUid());
        params.add(record.getRecordTime());
        params.add(record.getGiftKey());
        params.add(record.getPlatformId());
        params.add(record.getGameId());
        params.add(record.getGameType());
        params.add(record.getPackageId());
        this.getJdbcTemplate().update(sql, params.toArray());
    }

    @Override
    public int countUserGiftRecord(Long uid, Integer gameType) {
        int index = KeyIndexUtils.getUserTableIndex(uid);
        String sql = "select count(1) from user_gift_record_" + index + " where uid=? ";
        ArrayList<Number> params = new ArrayList<Number>();
        params.add(uid);
        if (gameType != 0) {
            sql = sql + " and gameType=? ";
            params.add(gameType);
        }
        return this.getJdbcTemplate().queryForInt(sql, params.toArray());
    }

    @Override
    public List<UserGiftRecordDTO> getUserGiftRecord(Long uid, Integer gameType, int pageNo, int pageSize) {
        int index = KeyIndexUtils.getUserTableIndex(uid);
        String sql_1 = "SELECT u.uid, u.recordTime, u.giftKey, u.gameType, u.packageId,  \np.packageName, p.packageName, p.startTime, p.endTime, p.packageStatus, g.logo\nFROM user_gift_record_" + index + " u  \n" + "LEFT JOIN package_webgame_gift p ON p.seqid=u.packageId\n" + "LEFT JOIN package_games g ON g.seqid=u.gameId\n" + "WHERE u.uid=? AND u.gameType=1 ";
        String sql_2 = " SELECT u.uid, u.recordTime, u.giftKey, u.gameType, u.packageId,   \np.packageName, p.packageName, p.startTime, p.endTime, p.packageStatus, g.logo\nFROM user_gift_record_" + index + " u  \n" + "LEFT JOIN package_mobilegame_gift p ON p.seqid=u.packageId\n" + "LEFT JOIN package_games g ON g.seqid=u.gameId\n" + "WHERE u.uid=? AND u.gameType=2 ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(uid);
        StringBuilder sql = new StringBuilder();
        if (gameType == 1) {
            sql.append(sql_1);
        } else if (gameType == 2) {
            sql.append(sql_2);
        } else {
            sql.append(sql_1).append(" union ").append(sql_2);
            params.add(uid);
        }
        sql.append(" ORDER BY recordTime DESC LIMIT ?,? ");
        params.add((pageNo - 1) * pageSize);
        params.add(pageSize);
        return this.executeQuery(UserGiftRecordDTO.class, sql.toString(), params);
    }

    @Override
    public void test1() {
        this.getJdbcTemplate().execute("INSERT INTO niux_giftcenter.user_gift_record(uid,recordTime,giftKey,platformId,gameId,gameType,packageId) VALUES ( '3','3','3','3','3','3','3'); ");
    }

    @Override
    public void test2() {
        this.getJdbcTemplate().execute("INSERT INTO niux_giftcenter.user_gift_record(uid,recordTime,giftKey,platformId,gameId,gameType,packageId) VALUES ( '3a','3','3','3','3','3','3'); ");
    }

    @Override
    public List<SearchPackageDTO> searchGift(String keyword) {
        String sqlWeb = "SELECT gift.seqid AS packageId, gift.packageName, gift.packageContent, gift.startTime, gift.endTime,\ngame.gameName, game.gameType, \nnum.total, num.used\nFROM package_webgame_gift gift\nLEFT JOIN package_games game ON game.seqid=gift.gameId\nLEFT JOIN package_gift_number num ON num.packageId=gift.seqid\nWHERE gift.packageStatus=1  AND gift.packageName LIKE ?\nORDER BY endTime DESC ";
        String sqlMobile = "SELECT gift.seqid AS packageId, gift.packageName, gift.packageContent, gift.startTime, gift.endTime,\ngame.gameName, game.gameType, \nnum.total, num.used\nFROM package_mobilegame_gift gift\nLEFT JOIN package_games game ON game.seqid=gift.gameId\nLEFT JOIN package_gift_number num ON num.packageId=gift.seqid\nWHERE gift.packageStatus=1  AND gift.packageName LIKE ?\nORDER BY endTime DESC ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("%" + keyword + "%");
        List<SearchPackageDTO> list1 = this.executeQuery(SearchPackageDTO.class, sqlWeb, params);
        List<SearchPackageDTO> list2 = this.executeQuery(SearchPackageDTO.class, sqlMobile, params);
        list1.addAll(list2);
        return list1;
    }
}

