/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.giftcenter.dao.PackageKeyDao;
import com.xunlei.niux.data.giftcenter.util.KeyIndexUtils;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;

public class PackageKeyDaoImpl
extends BaseDaoImpl
implements PackageKeyDao {
    @Override
    public void createPackageWebgameKeyTable(Long packageId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = "CREATE TABLE package_webgame_gift_key_" + index + " (\n" + "  seqid BIGINT(20) NOT NULL AUTO_INCREMENT,\n" + "  packageId BIGINT(20) NOT NULL,\n" + "  gameId BIGINT(20) NOT NULL,\n" + "  platformId BIGINT(20) NOT NULL,\n" + "  giftKey VARCHAR(100) NOT NULL,\n" + "  receivedUid VARCHAR(20) DEFAULT NULL,\n" + "  receivedTime VARCHAR(19) DEFAULT NULL,\n" + "  keyStatus TINYINT(1) NOT NULL DEFAULT '0',\n" + "  PRIMARY KEY (seqid),\n" + "  UNIQUE KEY pkg_key (packageId,giftKey) \n" + ") ENGINE=INNODB DEFAULT CHARSET=utf8";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public void createPackageMobilegameKeyTable(Long packageId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = "CREATE TABLE package_mobilegame_gift_key_" + index + " (\n" + "  seqid BIGINT(20) NOT NULL AUTO_INCREMENT,\n" + "  packageId BIGINT(20) NOT NULL,\n" + "  gameId BIGINT(20) NOT NULL,\n" + "  platformId BIGINT(20) NOT NULL,\n" + "  giftKey VARCHAR(100) NOT NULL,\n" + "  receivedUid VARCHAR(20) DEFAULT NULL,\n" + "  receivedTime VARCHAR(19) DEFAULT NULL,\n" + "  keyStatus TINYINT(1) NOT NULL DEFAULT '0',\n" + "  PRIMARY KEY (seqid),\n" + "  UNIQUE KEY pkg_key (packageId,giftKey) \n" + ") ENGINE=INNODB DEFAULT CHARSET=utf8";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public int saveWebGiftKey(final List<String> list, final PackageWebgameGift packageWebgameGift) {
        final Long packageId = packageWebgameGift.getSeqid();
        if (this.isNotExistsWebgameKeyTable(packageId)) {
            this.createPackageWebgameKeyTable(packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = "insert into package_webgame_gift_key_" + index + " (platformId,gameId,packageId,giftKey,keyStatus) values (?,?,?,?,?)";
        int[] arr = this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                String key = (String)list.get(i);
                ps.setLong(1, packageWebgameGift.getPlatformId());
                ps.setLong(2, packageWebgameGift.getGameId());
                ps.setLong(3, packageId);
                ps.setString(4, key);
                ps.setInt(5, 0);
            }

            @Override
            public int getBatchSize() {
                return list.size();
            }
        });
        int num = 0;
        for (int i : arr) {
            if (i <= 0) continue;
            ++num;
        }
        return num;
    }

    @Override
    public int saveMobileGiftKey(final List<String> list, final PackageMobilegameGift packageMobilegameGift) {
        Long packageId = packageMobilegameGift.getSeqid();
        if (this.isNotExistsMobilegameKeyTable(packageId)) {
            this.createPackageMobilegameKeyTable(packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageMobilegameGift.getSeqid());
        String sql = "insert into package_mobilegame_gift_key_" + index + " (platformId,gameId,packageId,giftKey,keyStatus) values (?,?,?,?,?)";
        int[] arr = this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                String key = (String)list.get(i);
                ps.setLong(1, packageMobilegameGift.getPlatformId());
                ps.setLong(2, packageMobilegameGift.getGameId());
                ps.setLong(3, packageMobilegameGift.getSeqid());
                ps.setString(4, key);
                ps.setInt(5, 0);
            }

            @Override
            public int getBatchSize() {
                return list.size();
            }
        });
        int num = 0;
        for (int i : arr) {
            if (i <= 0) continue;
            ++num;
        }
        return num;
    }

    @Override
    public int countPackageWebgameGiftKey(Long packageId, Long gameId, Long platformId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT count(1) FROM niux_giftcenter.package_webgame_gift_key_" + index + " where packageId=" + packageId;
        sql.append(cntSql);
        if (gameId != null && gameId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        if (platformId != null && platformId != 0L) {
            sql.append(" and platformId=" + platformId);
        }
        return this.getJdbcTemplate().queryForInt(sql.toString());
    }

    @Override
    public int countPackageMobilegameGiftKey(Long packageId, Long gameId, Long platformId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT count(1) FROM niux_giftcenter.package_mobilegame_gift_key_" + index + " where packageId=" + packageId;
        sql.append(cntSql);
        if (gameId != null && gameId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        if (platformId != null && platformId != 0L) {
            sql.append(" and platformId=" + platformId);
        }
        return this.getJdbcTemplate().queryForInt(sql.toString());
    }

    @Override
    public List<PackageWebgameGiftKey> getPackageWebgameGiftKey(Long packageId, Long gameId, Long platformId, int pageNo, int pageSize) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT * FROM niux_giftcenter.package_webgame_gift_key_" + index + " where packageId=" + packageId;
        sql.append(cntSql);
        if (gameId != null && gameId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        if (platformId != null && platformId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        sql.append(" limit " + pageNo + ", " + pageSize);
        return this.executeQuery(PackageWebgameGiftKey.class, sql.toString(), new ArrayList<Object>());
    }

    @Override
    public List<PackageMobilegameGiftKey> getPackageMobilegameGiftKey(Long packageId, Long gameId, Long platformId, int pageNo, int pageSize) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT * FROM niux_giftcenter.package_mobilegame_gift_key_" + index + " where packageId=" + packageId;
        sql.append(cntSql);
        if (gameId != null && gameId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        if (platformId != null && platformId != 0L) {
            sql.append(" and gameId=" + gameId);
        }
        sql.append(" limit " + pageNo + ", " + pageSize);
        return this.executeQuery(PackageMobilegameGiftKey.class, sql.toString(), new ArrayList<Object>());
    }

    @Override
    public void addPackageGiftNumber(Long packageId, int i, int addNum) {
        String sql = "insert into package_gift_number1";
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public boolean isNotExistsWebgameKeyTable(Long packageId) {
        String table = "package_webgame_gift_key_" + KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = "SELECT COUNT(1) FROM information_schema.tables WHERE table_name=?";
        int cnt = this.getJdbcTemplate().queryForInt(sql, new String[]{table});
        return cnt == 0;
    }

    @Override
    public boolean isNotExistsMobilegameKeyTable(Long packageId) {
        String table = "package_mobilegame_gift_key_" + KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = "SELECT COUNT(1) FROM information_schema.tables WHERE table_name=?";
        int cnt = this.getJdbcTemplate().queryForInt(sql, new String[]{table});
        return cnt == 0;
    }

    @Override
    public Map<String, Integer> countWebKey(Long packageId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String totalSql = "SELECT count(1) FROM niux_giftcenter.package_webgame_gift_key_" + index + " where packageId=?";
        String usedSql = "SELECT count(1) FROM niux_giftcenter.package_webgame_gift_key_" + index + " where keyStatus=1 and receivedUid is not null and packageId=?";
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(packageId);
        int total = this.getJdbcTemplate().queryForInt(totalSql, params.toArray());
        int used = this.getJdbcTemplate().queryForInt(usedSql, params.toArray());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("total", total);
        map.put("used", used);
        return map;
    }

    @Override
    public Map<String, Integer> countMobileKey(Long packageId) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String totalSql = "SELECT count(1) FROM niux_giftcenter.package_mobilegame_gift_key_" + index + " where packageId=?";
        String usedSql = "SELECT count(1) FROM niux_giftcenter.package_mobilegame_gift_key_" + index + " where keyStatus=1 and receivedUid is not null and packageId=?";
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(packageId);
        int total = this.getJdbcTemplate().queryForInt(totalSql, params.toArray());
        int used = this.getJdbcTemplate().queryForInt(usedSql, params.toArray());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("total", total);
        map.put("used", used);
        return map;
    }

    @Override
    public int usePackageWebgameGiftKey(Long packageId, String uid) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = " UPDATE package_webgame_gift_key_" + index + " a,\n" + "(SELECT COUNT(1) AS cnt FROM package_webgame_gift_key_" + index + " WHERE receivedUid=? AND packageId=?) b,\n" + "(SELECT MIN(seqid) AS seqid FROM package_webgame_gift_key_" + index + "  WHERE packageId=? AND keyStatus=0) c\n" + "SET a.receivedUid=?,a.receivedTime=NOW(),a.keyStatus=1 \n" + "WHERE b.cnt=0 AND a.seqid=c.seqid ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(uid);
        params.add(packageId);
        params.add(packageId);
        params.add(uid);
        return this.getJdbcTemplate().update(sql, params.toArray());
    }

    @Override
    public int usePackageMobilegameGiftKey(Long packageId, String uid) {
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String sql = " UPDATE package_mobilegame_gift_key_" + index + " a,\n" + "(SELECT COUNT(1) AS cnt FROM package_mobilegame_gift_key_" + index + " WHERE receivedUid=? AND packageId=?) b,\n" + "(SELECT MIN(seqid) AS seqid FROM package_mobilegame_gift_key_" + index + "  WHERE packageId=? AND keyStatus=0) c\n" + "SET a.receivedUid=?,a.receivedTime=NOW(),a.keyStatus=1 \n" + "WHERE b.cnt=0 AND a.seqid=c.seqid ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(uid);
        params.add(packageId);
        params.add(packageId);
        params.add(uid);
        return this.getJdbcTemplate().update(sql, params.toArray());
    }

    @Override
    public PackageWebgameGiftKey queryPackageWebgameGiftKey(Long packageId, String receivedUid) {
        List<PackageWebgameGiftKey> list;
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT * FROM niux_giftcenter.package_webgame_gift_key_" + index + " where packageId=?";
        sql.append(cntSql);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        if (StringUtils.isNotEmpty(receivedUid)) {
            sql.append(" and receivedUid=?");
            params.add(receivedUid);
        }
        if ((list = this.executeQuery(PackageWebgameGiftKey.class, sql.toString(), params)) == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public PackageMobilegameGiftKey queryPackageMobilegameGiftKey(Long packageId, String receivedUid) {
        List<PackageMobilegameGiftKey> list;
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        StringBuilder sql = new StringBuilder();
        String cntSql = "SELECT * FROM niux_giftcenter.package_mobilegame_gift_key_" + index + " where packageId=?";
        sql.append(cntSql);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        if (StringUtils.isNotEmpty(receivedUid)) {
            sql.append(" and receivedUid=?");
            params.add(receivedUid);
        }
        if ((list = this.executeQuery(PackageMobilegameGiftKey.class, sql.toString(), params)) == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void raisePackagePickupNumber(Long packageId, Integer gameType) {
        String findSql = "select count(1) from package_pickup_number where packageId=? and gameType=?";
        String insertSql = "insert into package_pickup_number (packageId,gameType,times) values (?,?,1)";
        String updateSql = "update package_pickup_number set times=times+1 where packageId=? and gameType=?";
        ArrayList<Number> params = new ArrayList<Number>();
        params.add(packageId);
        params.add(gameType);
        Object[] arr = params.toArray();
        if (this.getJdbcTemplate().queryForInt(findSql, arr) == 0) {
            this.getJdbcTemplate().update(insertSql, arr);
        } else {
            this.getJdbcTemplate().update(updateSql, arr);
        }
    }
}

