/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.XLGiftCenterBo;
import com.xunlei.niux.data.giftcenter.dao.AdvBaseDao;
import com.xunlei.niux.data.giftcenter.dao.PackageKeyDao;
import com.xunlei.niux.data.giftcenter.dao.UserDao;
import com.xunlei.niux.data.giftcenter.dto.PackageMobilegameGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.PackageWebgameGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.SearchPackageDTO;
import com.xunlei.niux.data.giftcenter.dto.UserGiftRecordDTO;
import com.xunlei.niux.data.giftcenter.util.KeyIndexUtils;
import com.xunlei.niux.data.giftcenter.vo.BookingGiftRecord;
import com.xunlei.niux.data.giftcenter.vo.PackageGiftNumber;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.UserGiftRecord;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XLGiftCenterBoImpl
implements XLGiftCenterBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private PackageKeyDao packageKeyDao;
    @Autowired
    private AdvBaseDao advBaseDao;
    @Autowired
    private UserDao userDao;

    @Override
    public int countPackageWebgameGift(String queryType) {
        String selSql = " SELECT count(1) FROM package_webgame_gift WHERE 1=1 and packageStatus=1 ";
        StringBuilder sql = new StringBuilder();
        sql.append(selSql);
        if ("1".equals(queryType)) {
            sql.append(" AND startTime<=NOW() AND endTime>=NOW() ");
        } else if ("2".equals(queryType)) {
            sql.append(" AND endTime<NOW() ");
        }
        sql.append(" order by startTime desc ");
        return this.advBaseDao.count(sql.toString());
    }

    @Override
    public int countPackageMobilegameGift(String queryType) {
        String selSql = " SELECT count(1) FROM package_mobilegame_gift WHERE 1=1 and packageStatus=1 ";
        StringBuilder sql = new StringBuilder();
        sql.append(selSql);
        if ("1".equals(queryType)) {
            sql.append(" AND startTime<=NOW() AND endTime>=NOW() ");
        } else if ("2".equals(queryType)) {
            sql.append(" AND endTime<NOW() ");
        }
        sql.append(" order by startTime desc ");
        return this.advBaseDao.count(sql.toString());
    }

    @Override
    public List<PackageWebgameGiftDTO> getPackageWebgameGift(String queryType, int pageNo, int pageSize) {
        ArrayList<PackageWebgameGiftDTO> data = new ArrayList<PackageWebgameGiftDTO>();
        String selSql = " SELECT gift.seqid AS packageId, gift.packageName, gift.packageContent, gift.activationTips, gift.gameUrl, \ngift.packageStatus, gift.startTime, gift.endTime, gift.needXLVip, gift.needPhone, \ngame.gameType, game.logo, game.gameName, game.description, num.total, num.used \nFROM package_webgame_gift gift \nLEFT JOIN package_gift_number num ON num.packageId=gift.seqid\nLEFT JOIN package_games game ON gift.gameId=game.seqid\nWHERE 1=1 AND gift.packageStatus=1 and num.gameType=1";
        StringBuilder sql = new StringBuilder();
        sql.append(selSql);
        if ("1".equals(queryType)) {
            sql.append(" AND gift.startTime<=NOW() AND gift.endTime>=NOW() ");
        } else if ("2".equals(queryType)) {
            sql.append(" AND gift.endTime<NOW() ");
        }
        sql.append(" order by gift.startTime desc ");
        sql.append(" limit :pageNo, :pageSize");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageNo", (pageNo - 1) * pageSize);
        params.put("pageSize", pageSize);
        List<?> list = this.advBaseDao.queryList(PackageWebgameGiftDTO.class, sql.toString(), params);
        for (Object obj : list) {
            data.add((PackageWebgameGiftDTO)obj);
        }
        return data;
    }

    @Override
    public List<PackageMobilegameGiftDTO> getPackageMobilegameGift(String queryType, int pageNo, int pageSize) {
        ArrayList<PackageMobilegameGiftDTO> data = new ArrayList<PackageMobilegameGiftDTO>();
        String selSql = " SELECT gift.seqid AS packageId, gift.packageName, gift.packageContent, gift.activationTips, gift.iosUrl, gift.androidUrl, \ngift.packageStatus, gift.startTime, gift.endTime, gift.needXLVip, gift.needPhone, \ngame.gameType, game.logo, game.gameName, game.description,  num.total, num.used \nFROM package_mobilegame_gift gift \nLEFT JOIN package_gift_number num ON num.packageId=gift.seqid\nLEFT JOIN package_games game ON gift.gameId=game.seqid\nWHERE 1=1 AND gift.packageStatus=1 and num.gameType=2 ";
        StringBuilder sql = new StringBuilder();
        sql.append(selSql);
        if ("1".equals(queryType)) {
            sql.append(" AND gift.startTime<=NOW() AND gift.endTime>=NOW() ");
        } else if ("2".equals(queryType)) {
            sql.append(" AND gift.endTime<NOW() ");
        }
        sql.append(" order by gift.startTime desc ");
        sql.append(" limit :pageNo, :pageSize");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageNo", (pageNo - 1) * pageSize);
        params.put("pageSize", pageSize);
        List<?> list = this.advBaseDao.queryList(PackageMobilegameGiftDTO.class, sql.toString(), params);
        for (Object obj : list) {
            data.add((PackageMobilegameGiftDTO)obj);
        }
        return data;
    }

    @Override
    @Transactional
    public PackageWebgameGiftKey releaseWebKey(Long uid, Long packageId) {
        PackageWebgameGift gift = this.baseDao.findById(PackageWebgameGift.class, packageId);
        if (gift == null) {
            throw new XLRuntimeException("not found web packageId=" + packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String findKeySql = "select * from package_webgame_gift_key_" + index + " where packageId=? for update";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        List<PackageWebgameGiftKey> list = this.baseDao.executeQuery(PackageWebgameGiftKey.class, findKeySql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        int used = this.packageKeyDao.usePackageWebgameGiftKey(packageId, uid + "");
        if (used == 0) {
            throw new XLRuntimeException("fatal use web key. uid=" + uid + " packageId=" + packageId);
        }
        PackageWebgameGiftKey key = this.packageKeyDao.queryPackageWebgameGiftKey(packageId, uid + "");
        if (key == null) {
            throw new XLRuntimeException("fatal update web key. uid=" + uid + " packageId=" + packageId);
        }
        UserGiftRecord record = new UserGiftRecord();
        record.setUid(uid);
        record.setRecordTime(DateUtil.formatNowByDefault());
        record.setGiftKey(key.getGiftKey());
        record.setPlatformId(gift.getPlatformId());
        record.setGameId(gift.getGameId());
        record.setGameType(1);
        record.setPackageId(gift.getSeqid());
        this.userDao.insertUserTable(record);
        return key;
    }

    @Override
    @Transactional
    public PackageMobilegameGiftKey releaseMobileKey(Long uid, Long packageId) {
        PackageMobilegameGift gift = this.baseDao.findById(PackageMobilegameGift.class, packageId);
        if (gift == null) {
            throw new XLRuntimeException("not found mobile packageId=" + packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String findKeySql = "select * from package_mobilegame_gift_key_" + index + " where packageId=? for update";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        List<PackageMobilegameGiftKey> list = this.baseDao.executeQuery(PackageMobilegameGiftKey.class, findKeySql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        int used = this.packageKeyDao.usePackageMobilegameGiftKey(packageId, uid + "");
        if (used == 0) {
            throw new XLRuntimeException("fatal use mobile key. uid=" + uid + " packageId=" + packageId);
        }
        PackageMobilegameGiftKey key = this.packageKeyDao.queryPackageMobilegameGiftKey(packageId, uid + "");
        if (key == null) {
            throw new XLRuntimeException("fatal update mobile key. uid=" + uid + " packageId=" + packageId);
        }
        UserGiftRecord record = new UserGiftRecord();
        record.setUid(uid);
        record.setRecordTime(DateUtil.formatNowByDefault());
        record.setGiftKey(key.getGiftKey());
        record.setPlatformId(gift.getPlatformId());
        record.setGameId(gift.getGameId());
        record.setGameType(2);
        record.setPackageId(gift.getSeqid());
        this.userDao.insertUserTable(record);
        return key;
    }

    @Override
    public boolean hasGiftNum(Long packageId, Integer gameType) {
        PackageGiftNumber queryNum = new PackageGiftNumber();
        queryNum.setPackageId(packageId);
        queryNum.setGameType(gameType);
        List<PackageGiftNumber> numList = this.baseDao.findByObject(PackageGiftNumber.class, queryNum, new Page());
        if (numList == null || numList.size() == 0) {
            throw new XLRuntimeException("None gift or Error num of gift, pacakgeId=" + packageId + ", gameType=" + gameType);
        }
        PackageGiftNumber num = numList.get(0);
        return num.getTotal() > num.getUsed();
    }

    @Override
    public int countUserGiftRecord(Long uid, Integer gameType) {
        return this.userDao.countUserGiftRecord(uid, gameType);
    }

    @Override
    public List<UserGiftRecordDTO> getUserGiftRecord(Long uid, Integer gameType, int pageNo, int pageSize) {
        return this.userDao.getUserGiftRecord(uid, gameType, pageNo, pageSize);
    }

    @Override
    public boolean hasUserGiftRecord(Long uid, Long packageId, Integer gameType) {
        if (this.userDao.isNotExistsUserTable(uid)) {
            return false;
        }
        int index = KeyIndexUtils.getUserTableIndex(uid);
        String sql = "select count(1) from user_gift_record_" + index + " where uid=:uid and packageId=:packageId and gameType=:gameType";
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("uid", uid);
        map.put("packageId", packageId);
        map.put("gameType", gameType);
        return this.advBaseDao.count(sql, map) > 0;
    }

    @Override
    @Transactional
    public PackageWebgameGiftKey pickupWebKey(Long uid, Long packageId) {
        PackageWebgameGift gift = this.baseDao.findById(PackageWebgameGift.class, packageId);
        if (gift == null) {
            throw new XLRuntimeException("not found web packageId=" + packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String findKeySql = " SELECT * FROM package_webgame_gift_key_" + index + " \n" + "WHERE packageId=? AND keyStatus=1 AND (receivedTime <= NOW() - INTERVAL 1 DAY)  ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        List<PackageWebgameGiftKey> list = this.baseDao.executeQuery(PackageWebgameGiftKey.class, findKeySql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        Random random = new Random();
        PackageWebgameGiftKey key = list.get(random.nextInt(list.size()));
        this.packageKeyDao.raisePackagePickupNumber(packageId, 1);
        return key;
    }

    @Override
    @Transactional
    public PackageMobilegameGiftKey pickupMobileKey(Long uid, Long packageId) {
        PackageMobilegameGift gift = this.baseDao.findById(PackageMobilegameGift.class, packageId);
        if (gift == null) {
            throw new XLRuntimeException("not found mobile packageId=" + packageId);
        }
        int index = KeyIndexUtils.getKeyTableIndex(packageId);
        String findKeySql = " SELECT * FROM package_mobilegame_gift_key_" + index + " \n" + "WHERE packageId=? AND keyStatus=1 AND (receivedTime <= NOW() - INTERVAL 1 DAY)  ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(packageId);
        List<PackageMobilegameGiftKey> list = this.baseDao.executeQuery(PackageMobilegameGiftKey.class, findKeySql, params);
        if (list == null || list.size() == 0) {
            return null;
        }
        Random random = new Random();
        PackageMobilegameGiftKey key = list.get(random.nextInt(list.size()));
        this.packageKeyDao.raisePackagePickupNumber(packageId, 2);
        return key;
    }

    @Override
    public void addBookingGiftRecord(Long uid, Long packageId, Integer gameType) {
        BookingGiftRecord bookingGiftRecord = new BookingGiftRecord();
        bookingGiftRecord.setUid(uid);
        bookingGiftRecord.setBookTime(DateUtil.formatNowByDefault());
        bookingGiftRecord.setPackageId(packageId);
        bookingGiftRecord.setGameType(gameType);
        bookingGiftRecord.setExpired(0);
        if (gameType == 1) {
            PackageWebgameGift gift = this.baseDao.findById(PackageWebgameGift.class, packageId);
            if (gift == null) {
                throw new XLRuntimeException("not found web packageId=" + packageId);
            }
            bookingGiftRecord.setPackageStartTime(gift.getStartTime());
            bookingGiftRecord.setPackageEndTime(gift.getEndTime());
            bookingGiftRecord.setPackageName(gift.getPackageName());
        } else if (gameType == 2) {
            PackageMobilegameGift gift = this.baseDao.findById(PackageMobilegameGift.class, packageId);
            if (gift == null) {
                throw new XLRuntimeException("not found mobile packageId=" + packageId);
            }
            bookingGiftRecord.setPackageStartTime(gift.getStartTime());
            bookingGiftRecord.setPackageEndTime(gift.getEndTime());
            bookingGiftRecord.setPackageName(gift.getPackageName());
        } else {
            throw new XLRuntimeException("not found packageid=" + packageId + ", gameType=" + gameType);
        }
        this.baseDao.insert(bookingGiftRecord);
    }

    @Override
    public List<SearchPackageDTO> searchGift(String keyword) {
        return this.userDao.searchGift(keyword);
    }

    @Override
    public void test() {
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println(AopUtils.isAopProxy(this));
        System.out.println(AopUtils.isCglibProxy(this));
        System.out.println(AopUtils.isJdkDynamicProxy(this));
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.userDao.test1();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.userDao.test2();
    }

    public AdvBaseDao getAdvBaseDao() {
        return this.advBaseDao;
    }

    public void setAdvBaseDao(AdvBaseDao advBaseDao) {
        this.advBaseDao = advBaseDao;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public PackageKeyDao getPackageKeyDao() {
        return this.packageKeyDao;
    }

    public void setPackageKeyDao(PackageKeyDao packageKeyDao) {
        this.packageKeyDao = packageKeyDao;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

