/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.giftcenter.bo.PackageWebGameServerOpenBo;
import com.xunlei.niux.data.giftcenter.dao.PackageWebGameServerOpenDao;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackageWebGameServerOpenBoImpl
implements PackageWebGameServerOpenBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private PackageWebGameServerOpenDao packageWebGameServerOpenDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public PackageWebGameServerOpenDao getPackageWebGameServerOpenDao() {
        return this.packageWebGameServerOpenDao;
    }

    public void setPackageWebGameServerOpenDao(PackageWebGameServerOpenDao packageWebGameServerOpenDao) {
        this.packageWebGameServerOpenDao = packageWebGameServerOpenDao;
    }

    @Override
    public List<Map<String, Object>> getWebGameServerOpens(String startDay, String endDay, int pageNo, int pageSize) {
        return this.packageWebGameServerOpenDao.getWebGameServerOpens(startDay, endDay, pageNo, pageSize);
    }

    @Override
    public Map<String, List<Map<String, Object>>> getWebGameServerOpensByTimeArray(String day, int startTime, int endTime, int pageNo, int pageSize) {
        List<Map<String, Object>> list;
        List<Map<String, Object>> opens = this.packageWebGameServerOpenDao.getWebGameServerOpens(day, day, pageNo, pageSize);
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (int i = startTime; i <= endTime; ++i) {
            String stri = i + "";
            String time = (stri.length() == 1 ? "0" + stri : stri) + ":00:00";
            list = new ArrayList();
            map.put(time, list);
        }
        for (Map<String, Object> open : opens) {
            String openTime = (String)open.get("opentime");
            open.put("openServerTime", open.get("openday").toString().substring(5, 10) + " " + openTime.substring(0, 5));
            open.put("type", this.getType(open));
            list = (List)map.get(openTime);
            if (list == null) continue;
            list.add(open);
        }
        return map;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getWebGameServerOpensByTimeArray(String day, int pageNo, int pageSize) {
        return this.getWebGameServerOpensByTimeArray(day, 8, 22, pageNo, pageSize);
    }

    @Override
    public List<Map<String, Object>> getWebGameServerOpensByTime(String day, String time, int pageNo, int pageSize) {
        List<Map<String, Object>> byTime = this.packageWebGameServerOpenDao.getWebGameServerOpensByTime(day, time, pageNo, pageSize);
        for (Map<String, Object> open : byTime) {
            String openTime = (String)open.get("opentime");
            open.put("openServerTime", open.get("openday").toString().substring(5, 10) + " " + openTime.substring(0, 5));
            open.put("type", this.getType(open));
        }
        return byTime;
    }

    private String getType(Map open) {
        String type = "";
        Date now = new Date();
        try {
            Date openServerTime = DateUtils.parseDate(open.get("openday") + " " + open.get("opentime"), new String[]{"yyyy-MM-dd HH:mm:ss"});
            long l = now.getTime() - openServerTime.getTime();
            type = l < 0L ? "\u5373\u5c06\u5f00\u670d" : (l <= 3600000L ? "\u706b\u7206\u5f00\u670d" : "\u5df2\u7ecf\u5f00\u670d");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return type;
    }
}

