/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.giftcenter.bo.IndexPageBo;
import com.xunlei.niux.data.giftcenter.dao.AdvBaseDao;
import com.xunlei.niux.data.giftcenter.dao.IndexPageDao;
import com.xunlei.niux.data.giftcenter.dto.MobileGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.RankingListMobileGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.RankingListWebGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.SearchGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.TopGiftOthersDTO;
import com.xunlei.niux.data.giftcenter.dto.WebHotGiftDTO;
import com.xunlei.niux.data.giftcenter.dto.WebTimeGiftDTO;
import com.xunlei.niux.data.giftcenter.util.ManufacturerDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndexPageBoImpl
implements IndexPageBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private IndexPageDao indexPageDao;
    @Autowired
    private AdvBaseDao advBaseDao;

    @Override
    public Map<String, Object> getTopGift() {
        return this.indexPageDao.getTopGift();
    }

    @Override
    public List<Map<String, Object>> getTopGiftOpenServer() {
        return this.indexPageDao.getTopGiftOpenServer();
    }

    @Override
    public List<Map<String, Object>> getTopGiftOthers() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT i.packageId,i.gameType, i.editTime, \nw.packageName,w.packageContent,w.activationTips,w.startTime,w.endTime FROM\n(SELECT * FROM index_page_recommended WHERE indexPosition=2 AND gameType=1) i\nLEFT JOIN package_webgame_gift w ON i.packageId=w.seqid\nUNION\nSELECT i.packageId,i.gameType, i.editTime, \nw.packageName,w.packageContent,w.activationTips,w.startTime,w.endTime FROM\n(SELECT * FROM index_page_recommended WHERE indexPosition=2 AND gameType=2) i\nLEFT JOIN package_mobilegame_gift w ON i.packageId=w.seqid\nORDER BY editTime DESC LIMIT 4 ";
        List<?> list = this.advBaseDao.queryList(TopGiftOthersDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            TopGiftOthersDTO dto = (TopGiftOthersDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("gameType", dto.getGameType());
            map.put("packageName", dto.getPackageName());
            map.put("packageContent", dto.getPackageContent());
            map.put("activationTips", dto.getActivationTips());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getWebTimeGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT i.packageId,i.gameType, i.ext1, i.ext2, i.pic1, \nw.packageName,w.packageContent,w.startTime,w.endTime FROM\n(SELECT * FROM index_page_recommended WHERE indexPosition=4 AND gameType=1) i\nLEFT JOIN package_webgame_gift w ON i.packageId=w.seqid\nORDER BY ext1 DESC  ";
        List<?> list = this.advBaseDao.queryList(WebTimeGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            WebTimeGiftDTO dto = (WebTimeGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("gameType", dto.getGameType());
            map.put("lastTime", dto.getExt1());
            map.put("nextTime", dto.getExt2());
            map.put("pic", dto.getPic1());
            map.put("packageName", dto.getPackageName());
            map.put("packageContent", dto.getPackageContent());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getWebHotGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT i.packageId, i.ext1, \nw.packageName,w.startTime,w.endTime, g.logo FROM\n(SELECT * FROM index_page_recommended WHERE indexPosition=3 AND gameType=1) i\nLEFT JOIN package_webgame_gift w ON i.packageId=w.seqid\n LEFT JOIN package_games g ON g.seqid=w.gameId ORDER BY ext1 DESC  ";
        List<?> list = this.advBaseDao.queryList(WebHotGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            WebHotGiftDTO dto = (WebHotGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("groupId", dto.getExt1());
            map.put("packageName", dto.getPackageName());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            map.put("logo", dto.getLogo());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getMobileGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT i.packageId,\nw.packageName, w.iosUrl, w.androidUrl, w.startTime, w.endTime, g.logo FROM\n(SELECT * FROM index_page_recommended WHERE indexPosition=5 AND gameType=2) i\nLEFT JOIN package_mobilegame_gift w ON i.packageId=w.seqid\n LEFT JOIN package_games g ON g.seqid=w.gameId ORDER BY i.editTime limit 30 ";
        List<?> list = this.advBaseDao.queryList(MobileGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            MobileGiftDTO dto = (MobileGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("packageName", dto.getPackageName());
            map.put("iosUrl", dto.getIosUrl());
            map.put("androidUrl", dto.getAndroidUrl());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            map.put("logo", dto.getLogo());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getWebOpen() {
        return this.indexPageDao.getWebOpen();
    }

    @Override
    public List<Map<String, Object>> getWebTest() {
        Map<String, String> map = ManufacturerDictionary.getWebGameTestType();
        List<Map<String, Object>> webTest = this.indexPageDao.getWebTest();
        for (Map<String, Object> objectMap : webTest) {
            objectMap.put("type", map.get(objectMap.get("type")));
            String time = (String)objectMap.get("time");
            objectMap.put("time", time.substring(0, 5));
        }
        return webTest;
    }

    @Override
    public List<Map<String, Object>> getMobileTest() {
        Map<String, String> map = ManufacturerDictionary.getWebGameTestType();
        List<Map<String, Object>> webTest = this.indexPageDao.getMobileTest();
        for (Map<String, Object> objectMap : webTest) {
            objectMap.put("type", map.get(objectMap.get("type")));
            String time = (String)objectMap.get("time");
            objectMap.put("time", time.substring(5, 10));
        }
        return webTest;
    }

    @Override
    public List<Map<String, Object>> getSearchGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT i.packageId, i.gameType, i.pic, i.showTxt, i.displayOrder, \nw.packageName,w.startTime,w.endTime FROM\n(SELECT * FROM index_page_search WHERE gameType=1) i\nLEFT JOIN package_webgame_gift w ON i.packageId=w.seqid\nUNION\nSELECT i.packageId, i.gameType, i.pic, i.showTxt, i.displayOrder, \nw.packageName,w.startTime,w.endTime FROM\n(SELECT * FROM index_page_search WHERE gameType=2) i\nLEFT JOIN package_mobilegame_gift w ON i.packageId=w.seqid\nORDER BY displayOrder LIMIT 5 ";
        List<?> list = this.advBaseDao.queryList(SearchGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            SearchGiftDTO dto = (SearchGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("gameType", dto.getGameType());
            map.put("pic", dto.getPic());
            map.put("showTxt", dto.getShowTxt());
            map.put("displayOrder", dto.getDisplayOrder());
            map.put("packageName", dto.getPackageName());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getRankingListWebGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT packageId,packageName,displayOrder,gameUrl,startTime,endTime FROM ranking_list_web_gift r \nLEFT JOIN package_webgame_gift p ON p.seqid=r.packageId\nORDER BY displayOrder ";
        List<?> list = this.advBaseDao.queryList(RankingListWebGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            RankingListWebGiftDTO dto = (RankingListWebGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("packageName", dto.getPackageName());
            map.put("displayOrder", dto.getDisplayOrder());
            map.put("gameUrl", dto.getGameUrl());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            data.add(map);
        }
        return data;
    }

    @Override
    public List<Map<String, Object>> getRankingListMobileGift() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String sql = " SELECT packageId,packageName,displayOrder,iosUrl,androidUrl,startTime,endTime FROM ranking_list_mobile_gift r \nLEFT JOIN package_mobilegame_gift p ON p.seqid=r.packageId\nORDER BY displayOrder ";
        List<?> list = this.advBaseDao.queryList(RankingListMobileGiftDTO.class, sql);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            RankingListMobileGiftDTO dto = (RankingListMobileGiftDTO)obj;
            map.put("packageId", dto.getPackageId());
            map.put("packageName", dto.getPackageName());
            map.put("displayOrder", dto.getDisplayOrder());
            map.put("iosUrl", dto.getIosUrl());
            map.put("androidUrl", dto.getAndroidUrl());
            map.put("startTime", dto.getStartTime());
            map.put("endTime", dto.getEndTime());
            data.add(map);
        }
        return data;
    }

    @Override
    public Map<String, Object> getBookingGift() {
        return this.indexPageDao.getBookingGift();
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

