/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.giftcenter.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.GiftCenterBo;
import com.xunlei.niux.data.giftcenter.dao.PackageKeyDao;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGiftNumber;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GiftCenterBoImpl
implements GiftCenterBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private PackageKeyDao packageKeyDao;

    @Override
    @Transactional
    public void importPackageWebgameKey(List<String> list, Long packageId) {
        PackageWebgameGift packageWebgameGift = this.baseDao.findById(PackageWebgameGift.class, packageId);
        if (packageWebgameGift == null) {
            throw new XLRuntimeException("Not Found with web game package id=" + packageId);
        }
        this.packageKeyDao.saveWebGiftKey(list, packageWebgameGift);
        this.adjustPackageNumber(packageId, 1);
    }

    @Override
    @Transactional
    public void importPackageMobilegameKey(List<String> list, Long packageId) {
        PackageMobilegameGift packageMobilegameGift = this.baseDao.findById(PackageMobilegameGift.class, packageId);
        if (packageMobilegameGift == null) {
            throw new XLRuntimeException("Not Found with mobile game package id=" + packageId);
        }
        this.packageKeyDao.saveMobileGiftKey(list, packageMobilegameGift);
        this.adjustPackageNumber(packageId, 2);
    }

    @Override
    public void adjustPackageNumber(Long packageId, Integer gameType) {
        Map<Object, Object> map = new HashMap();
        if (gameType == 1) {
            map = this.packageKeyDao.countWebKey(packageId);
        } else if (gameType == 2) {
            map = this.packageKeyDao.countMobileKey(packageId);
        }
        if (map == null || map.size() == 0) {
            return;
        }
        int total = (Integer)map.get("total");
        int used = (Integer)map.get("used");
        PackageGiftNumber pgn = new PackageGiftNumber();
        pgn.setPackageId(packageId);
        pgn.setGameType(gameType);
        PackageGiftNumber packageGiftNumber = FacadeFactory.INSTANCE.getBaseSo().findObject(pgn);
        if (packageGiftNumber == null) {
            packageGiftNumber = new PackageGiftNumber();
            packageGiftNumber.setPackageId(packageId);
            packageGiftNumber.setGameType(gameType);
            packageGiftNumber.setTotal(total);
            packageGiftNumber.setUsed(used);
            this.baseDao.insert(packageGiftNumber);
        } else {
            packageGiftNumber.setTotal(total);
            packageGiftNumber.setUsed(used);
            this.baseDao.updateById(packageGiftNumber);
        }
    }

    @Override
    public int countPackageWebgameGiftKey(Long packageId, Long gameId, Long platformId) {
        return this.packageKeyDao.countPackageWebgameGiftKey(packageId, gameId, platformId);
    }

    @Override
    public int countPackageMobilegameGiftKey(Long packageId, Long gameId, Long platformId) {
        return this.packageKeyDao.countPackageMobilegameGiftKey(packageId, gameId, platformId);
    }

    @Override
    public List<PackageWebgameGiftKey> getPackageWebgameGiftKey(Long packageId, Long gameId, Long platformId, int pageNo, int pageSize) {
        return this.packageKeyDao.getPackageWebgameGiftKey(packageId, gameId, platformId, pageNo, pageSize);
    }

    @Override
    public List<PackageMobilegameGiftKey> getPackageMobilegameGiftKey(Long packageId, Long gameId, Long platformId, int pageNo, int pageSize) {
        return this.packageKeyDao.getPackageMobilegameGiftKey(packageId, gameId, platformId, pageNo, pageSize);
    }

    public PackageKeyDao getPackageKeyDao() {
        return this.packageKeyDao;
    }

    public void setPackageKeyDao(PackageKeyDao packageKeyDao) {
        this.packageKeyDao = packageKeyDao;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

