/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeReceiveInfoDTO;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.util.Log;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class MemberInfoClient {
    private static Logger logger = Log.getLogger(MemberInfoClient.class);
    private static final String MemberUrl = "http://jinzuan.niu.xunlei.com:9090/member/";

    public static MemberShipDTO getMemberInfo(String userId) throws RuntimeException {
        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("\u53c2\u6570userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String url = "http://jinzuan.niu.xunlei.com:9090/member/getmember.do?uid=" + userId;
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + url);
        String resp = HttpClientUtil.get(url);
        logger.info("\u8bf7\u6c42\u7ed3\u679c\u4e3a\uff1a" + resp);
        JsonObject result = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = result.get("rtn").getAsInt();
        if (rtnCode == 0) {
            Gson gson = new Gson();
            JsonObject dataObject = result.getAsJsonObject("data");
            MemberShipDTO memberShip = null;
            if (dataObject.get("memberStatus") != null) {
                memberShip = new MemberShipDTO();
                memberShip.setMemberStatus(dataObject.get("memberStatus").getAsInt());
            } else {
                memberShip = gson.fromJson(dataObject.get("memberinfo"), MemberShipDTO.class);
                List priInfoList = (List)gson.fromJson(dataObject.get("prilist"), new TypeToken<List<PrivilegeReceiveInfoDTO>>(){}.getType());
                memberShip.setPrilist(priInfoList);
            }
            return memberShip;
        }
        if (rtnCode == 1) {
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (rtnCode == 2) {
            throw new RuntimeException("\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237\uff01");
        }
        if (rtnCode == 3) {
            throw new RuntimeException("\u7f51\u7edc\u5f02\u5e38\uff01");
        }
        if (rtnCode == 4) {
            throw new RuntimeException("\u65e0\u6548Ip\uff01");
        }
        throw new RuntimeException("\u672a\u77e5\u8fd4\u56de\u7801\uff1a" + rtnCode);
    }

    public static int getJinZuanLevel(String userId) {
        int level = 0;
        String cacheKey = MemberInfoClient.class + "userId_" + userId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            Map<String, Object> resultMap = MemberInfoClient.getBasicMemberInfo(userId);
            int code = Integer.parseInt(resultMap.get("code").toString());
            if (code != 0) {
                return level;
            }
            MemberShipDTO memberShipDTO = (MemberShipDTO)resultMap.get("data");
            if (memberShipDTO == null) {
                return 0;
            }
            int n = level = memberShipDTO.getLevelNum() == null || memberShipDTO.getLevelNum() < 0 ? 0 : memberShipDTO.getLevelNum();
            if (level > 0) {
                cacheManager.put(cacheKey, level, 5L);
            }
        } else {
            level = (Integer)object;
        }
        return level;
    }

    public static void main(String[] args) {
        Map<String, Object> memberShip = MemberInfoClient.getBasicMemberInfo("aaa");
        System.out.println("success!");
    }

    public static Map<String, Object> getBasicMemberInfo(String userId) {
        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("\u53c2\u6570userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String url = "http://jinzuan.niu.xunlei.com:9090/member/getmemberinfo.do?uid=" + userId;
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + url);
        String resp = HttpClientUtil.get(url);
        logger.info("\u8bf7\u6c42\u7ed3\u679c\u4e3a\uff1a" + resp);
        JsonObject result = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = result.get("rtn").getAsInt();
        if (rtnCode != 0) {
            String msg = result.get("data").getAsString();
            return MapEasyUtils.generateMap(rtnCode, msg);
        }
        Gson gson = new Gson();
        MemberShipDTO memberShip = gson.fromJson(result.get("data"), MemberShipDTO.class);
        return MapEasyUtils.generateMap(0, memberShip);
    }
}

