/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.gameinfo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class UserGameLoginDays {
    private static final Logger logger = Log.getLogger(UserGameLoginDays.class);
    private static final String Url = "http://dq2.niu.xunlei.com/act/getLoginDays?";

    public static int UserLonggestLoginDays(String userId, String fromDate, String toDate, String gameId, String serverId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("from", fromDate);
        params.put("to", toDate);
        params.put("gameId", gameId == null ? "" : gameId);
        params.put("serverId", serverId == null ? "" : serverId);
        String queryUrl = Url + SignUtil.getSignatureContent(params);
        logger.info("UserLonggestLoginDays query Url:" + queryUrl);
        String result = HttpClientUtil.get(queryUrl);
        logger.info("UserLonggestLoginDays query Result:" + result);
        JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
        int code = jsonObject.get("rtn").getAsInt();
        if (code != 0) {
            logger.error("URL:{} \u8bf7\u6c42\u5931\u8d25\uff01", (Object)queryUrl);
            return 0;
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(jsonObject.get("data"), new TypeToken<Map<String, Object>>(){}.getType());
        List dateStringList = (List)map.get("days");
        if (dateStringList.size() <= 0) {
            return 0;
        }
        return UserGameLoginDays.getLonggestDays(dateStringList);
    }

    private static int getLonggestDays(List<String> dateStringList) {
        String preDate = "";
        String curDate = "";
        int longgestDay = 0;
        int curContinuDay = 1;
        Iterator<String> i$ = dateStringList.iterator();
        while (i$.hasNext()) {
            String dateStr;
            curDate = dateStr = i$.next();
            if (StringUtils.isNotEmpty(preDate)) {
                if (UserGameLoginDays.isCurDateAfterPreDate(preDate, curDate)) {
                    ++curContinuDay;
                } else if (curContinuDay > longgestDay) {
                    longgestDay = curContinuDay;
                    curContinuDay = 1;
                }
            }
            preDate = curDate;
        }
        if (curContinuDay > longgestDay) {
            longgestDay = curContinuDay;
        }
        return longgestDay;
    }

    private static boolean isCurDateAfterPreDate(String preDate, String curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        try {
            calendar1.setTime(sdf.parse(preDate));
            calendar2.setTime(sdf.parse(curDate));
            int n = calendar2.get(6) - calendar1.get(6);
            return n == 1;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

