/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.daijinquan;

import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DaiJinQuanClient {
    private static Logger logger = Logger.getLogger(DaiJinQuanClient.class.getName());
    private static String daijinquanurl = "http://dy.niu.xunlei.com:80/card/updatecardcount.do?";

    public static void giveOut(String uid, String orderId, String type, long num, String bizNo, String bizPwd) {
        if (StringUtil.isEmpty(uid, orderId, bizNo, bizPwd, type)) {
            logger.error("uid[" + uid + "]orderId[" + orderId + "]bizNo[" + bizNo + "]type[" + type + "]");
            throw new RuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!"|100|200|300|500|1000|990|1490|".contains("|" + num + "|")) {
            logger.error("daijinquan num[" + num + "]");
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u4ee3\u91d1\u5238\u9762\u503c");
        }
        String dnum = num % 100L == 0L ? num / 100L + "" : (double)num * 1.0 / 100.0 + "";
        String sign = DaiJinQuanClient.sign(uid, type, orderId, dnum, bizNo, bizPwd);
        String djqurl = DaiJinQuanClient.concatUrl(uid, type, orderId, dnum, bizNo, sign);
        String resp = URLUtil.get(djqurl);
        DaiJinQuanClient.parseResp(resp);
    }

    private static void parseResp(String resp) {
        if (resp == null) {
            throw new NiuRuntimeException("99", "\u53d1\u653e\u4ee3\u91d1\u5238\u683c\u5f0f\u9519\u8bef");
        }
        if (resp.contains("\"rtn\":0") || resp.contains("\"rtn\":3")) {
            return;
        }
        if (resp.contains("\"rtn\":14")) {
            throw new NiuRuntimeException("1017", "\u5df2\u9886\u53d6\u5b8c");
        }
        throw new NiuRuntimeException("99", resp);
    }

    private static String sign(String uid, String type, String orderId, String dnum, String bizNo, String bizPwd) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", uid);
        map.put("type", type);
        map.put("bizino", bizNo);
        map.put("num1", dnum);
        map.put("orderid", orderId);
        return SignUtil.sign(map, bizPwd);
    }

    private static String concatUrl(String uid, String type, String orderId, String dnum, String bizNo, String sign) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", uid);
        map.put("type", type);
        map.put("bizino", bizNo);
        map.put("num1", dnum);
        map.put("orderid", orderId);
        map.put("sign", sign);
        String param = SignUtil.getSignatureContent(map);
        if (!daijinquanurl.contains("?")) {
            return daijinquanurl + "?" + param;
        }
        if (daijinquanurl.endsWith("&")) {
            return daijinquanurl + param;
        }
        return daijinquanurl + "&" + param;
    }
}

