/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.NetUtil;
import com.xunlei.util.concurrent.NamedThreadFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class NioSocketBootstrapFactory {
    private static final int DEFAULT_CONFIG_CONNECTTIMEOUTMILLIS = 5000;
    private static final int DEFAULT_CONFIG_RECEIVEBUFFERSIZE = 8192;
    private static final boolean DEFAULT_CONFIG_REUSEADDRESS = true;
    private static final int DEFAULT_CONFIG_SENDBUFFERSIZE = 8192;
    private static final int DEFAULT_CONFIG_SOLINGER = -1;
    private static final boolean DEFAULT_CONFIG_TCPKEEPALIVE = true;
    private static final boolean DEFAULT_CONFIG_TCPNODELAY = true;
    private static int workerCount = HttpServerConfig.CORE_PROCESSOR_NUM * 2;
    private static int plCorePoolSize = HttpServerConfig.CORE_PROCESSOR_NUM * 50;
    private static long plKeepAliveSecond = 60L;
    private static long plMaxChannelMemorySize = 0x6400000L;
    private static long plMaxTotalMemorySize = 0x40000000L;

    public static ExecutionHandler getExecutionHandler(String name) {
        return new ExecutionHandler(new OrderedMemoryAwareThreadPoolExecutor(plCorePoolSize, plMaxChannelMemorySize, plMaxTotalMemorySize, plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE-" + name + "#", 7)));
    }

    public static ClientBootstrap newClientBootstrap(ChannelPipelineFactory channelPipelineFactory, String name) {
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O client boss-" + name + "$", 10));
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O client worker-" + name + "$", 9));
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory(bossExecutor, workerExecutor, workerCount);
        ClientBootstrap bootstrap = new ClientBootstrap(channelFactory);
        bootstrap.setPipelineFactory(channelPipelineFactory);
        NioSocketBootstrapFactory.setBootstrapOptions(bootstrap);
        return bootstrap;
    }

    public static ServerBootstrap newServerBootstrap(ChannelPipelineFactory channelPipelineFactory, String name, int listen_port) {
        NetUtil.checkSocketPortBind(listen_port);
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server boss-" + name + "$", 10));
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server worker-" + name + "$", 9));
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory(bossExecutor, workerExecutor, workerCount);
        ServerBootstrap serverBootstrap = new ServerBootstrap(channelFactory);
        serverBootstrap.setPipelineFactory(channelPipelineFactory);
        NetUtil.setServerBootstrapOptions(serverBootstrap);
        ChannelException ex = null;
        try {
            Channel c = serverBootstrap.bind(new InetSocketAddress(listen_port));
        }
        catch (ChannelException e) {
            ex = e;
        }
        String msg = ex == null ? "OK" : "ERROR";
        String chnmsg = ex == null ? "NioServerSocket-" + name + "\u670d\u52a1\u542f\u52a8\u5b8c\u6bd5.(port[" + listen_port + "])" : "NioServerSocket-" + name + "\u670d\u52a1\u542f\u52a8\u5931\u8d25.(port[" + listen_port + "])";
        String errStr = ex == null ? "" : ex.getMessage();
        HttpServerConfig.ALARMLOG.error("NioServerSocket-{}(port[{}],workerCount[{}]) Start {}.", new Object[]{name, listen_port, workerCount, msg, ex});
        System.err.println(String.valueOf(chnmsg) + errStr);
        if (ex != null) {
            System.exit(1);
        }
        return serverBootstrap;
    }

    public static void setBootstrapOptions(Bootstrap bootstrap) {
        NioSocketBootstrapFactory.setBootstrapOptions(bootstrap, 5000, 8192, 8192);
    }

    public static void setBootstrapOptions(Bootstrap bootstrap, int connectTimeoutMillis, int receiveBufferSize, int sendBufferSize) {
        bootstrap.setOption("tcpNoDelay", true);
        bootstrap.setOption("soLinger", -1);
        bootstrap.setOption("reuseAddress", true);
        bootstrap.setOption("child.tcpNoDelay", true);
        bootstrap.setOption("child.soLinger", -1);
        bootstrap.setOption("child.reuseAddress", true);
        bootstrap.setOption("keepAlive", true);
        bootstrap.setOption("connectTimeoutMillis", connectTimeoutMillis);
        bootstrap.setOption("receiveBufferSize", receiveBufferSize);
        bootstrap.setOption("sendBufferSize", sendBufferSize);
        bootstrap.setOption("child.keepAlive", true);
        bootstrap.setOption("child.connectTimeoutMillis", connectTimeoutMillis);
        bootstrap.setOption("child.receiveBufferSize", receiveBufferSize);
        bootstrap.setOption("child.sendBufferSize", sendBufferSize);
    }
}

