/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.StatusPrinter;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XLAccessLogger
implements Context,
AppenderAttachable<AccessEvent>,
FilterAttachable<AccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "logback-access.xml";
    private long birthTime = System.currentTimeMillis();
    Object configurationLock = new Object();
    private String name;
    StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    private FilterAttachableImpl<AccessEvent> fai = new FilterAttachableImpl();
    AppenderAttachableImpl<AccessEvent> aai = new AppenderAttachableImpl();
    String filename;
    boolean quiet;
    boolean started;
    boolean alreadySetLogbackStatusManager = false;
    private boolean logEnable = true;
    private boolean logSuccess = false;
    private InnerLog logimpl;
    private static final InnerLog NOP_LOG = new InnerLog();
    private final InnerLog defaultLog = new DefaultLog();

    public XLAccessLogger() {
        this.start();
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public void setLogEanble(boolean enable) {
        this.logEnable = enable;
        this.logimpl = this.logEnable && this.logSuccess ? this.defaultLog : NOP_LOG;
    }

    public void start() {
        block18: {
            try {
                try {
                    AccessEvent.crackTest();
                }
                catch (Throwable e) {
                    String info = "logback-access is no crack for nettyHttpServer,make sure logaccess_crack.jar's class path order is prior to ori_logaccess.jar";
                    this.getStatusManager().add(new ErrorStatus(info, this));
                    if (!this.quiet) {
                        StatusPrinter.print(this.getStatusManager());
                    }
                    this.setLogEanble(true);
                    this.started = true;
                    return;
                }
                if (this.filename == null) {
                    try {
                        this.filename = this.getClass().getClassLoader().getResource(DEFAULT_CONFIG_FILE).getFile();
                        this.getStatusManager().add(new InfoStatus("filename property not set. Assuming [" + this.filename + "]", this));
                    }
                    catch (Throwable e) {
                        this.getStatusManager().add(new WarnStatus("[logback-access.xml] does not exist", this));
                        if (!this.quiet) {
                            StatusPrinter.print(this.getStatusManager());
                        }
                        this.setLogEanble(true);
                        this.started = true;
                        return;
                    }
                }
                try {
                    File configFile = new File(this.filename);
                    if (configFile.exists()) {
                        try {
                            JoranConfigurator jc = new JoranConfigurator();
                            jc.setContext(this);
                            jc.doConfigure(this.filename);
                            this.logSuccess = true;
                        }
                        catch (JoranException e) {
                            this.getStatusManager().add(new ErrorStatus("configure logback-access error", this, e));
                        }
                        break block18;
                    }
                    this.getStatusManager().add(new WarnStatus("[" + this.filename + "] does not exist", this));
                }
                catch (Throwable e) {
                    this.getStatusManager().add(new ErrorStatus("configure logback-access error", this, e));
                }
            }
            finally {
                if (!this.quiet) {
                    StatusPrinter.print(this.getStatusManager());
                }
                this.setLogEanble(true);
                this.started = true;
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void log(XLHttpRequest request, XLHttpResponse response) {
        this.logimpl.log(request, response);
    }

    public void stop() {
        this.started = false;
    }

    @Override
    public void addAppender(Appender<AccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<AccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<AccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<AccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<AccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public String getInfo() {
        return "Logback's implementation of ValveBase";
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void putProperty(String key, String val) {
        this.propertyMap.put(key, val);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    @Override
    public void addFilter(Filter<AccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<AccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(AccessEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("LogbackValve has been already given a name");
        }
        this.name = name;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    private class DefaultLog
    extends InnerLog {
        private DefaultLog() {
            super(null, null);
        }

        @Override
        public void log(XLHttpRequest request, XLHttpResponse response) {
            AccessEvent accessEvent = new AccessEvent(request, response);
            if (XLAccessLogger.this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
                return;
            }
            XLAccessLogger.this.aai.appendLoopOnAppenders(accessEvent);
        }
    }

    private static class InnerLog {
        private InnerLog() {
        }

        public void log(XLHttpRequest request, XLHttpResponse response) {
        }

        /* synthetic */ InnerLog(InnerLog innerLog, InnerLog innerLog2) {
            this();
        }
    }
}

