/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.async.AsyncProxyHandler;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.BasePageDispatcher;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.ResourceNotFoundError;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmdMapperDispatcher
extends BasePageDispatcher {
    @Autowired
    protected TextResponseHandlerManager handlerManager;

    protected Object _dispatch(XLContextAttachment attach) throws Exception {
        XLHttpRequest request = attach.getRequest();
        XLHttpResponse response = attach.getResponse();
        String path = request.getPath();
        CmdMappers.CmdMeta meta = this.cmdMappers.getCmdMeta(path);
        if (meta == null) {
            throw ResourceNotFoundError.INSTANCE;
        }
        attach.setCmdMeta(meta);
        this.config.getStatistics().cmdAccess(attach);
        if (meta.isDisable()) {
            throw ResourceNotFoundError.INSTANCE;
        }
        BaseCmd cmd = meta.getCmd();
        Method method = meta.getMethod();
        try {
            attach.registerProcessThread();
            Object object = method.invoke((Object)cmd, request, response);
            return object;
        }
        finally {
            attach.unregisterProcessThread();
        }
    }

    @Override
    protected void dispatch(XLContextAttachment attach) throws Exception {
        Object cmdReturnObj = null;
        try {
            try {
                cmdReturnObj = this._dispatch(attach);
            }
            catch (Throwable ex) {
                cmdReturnObj = this.handlerManager.handleThrowable(attach, ex);
                if (cmdReturnObj != AsyncProxyHandler.ASYNC_RESPONSE) {
                    this.handlerManager.writeResponse(attach, cmdReturnObj);
                }
            }
        }
        finally {
            if (cmdReturnObj != AsyncProxyHandler.ASYNC_RESPONSE) {
                this.handlerManager.writeResponse(attach, cmdReturnObj);
            }
        }
    }

    @Override
    public void init() {
        this.cmdMappers.initAutoMap();
        this.cmdMappers.initAnnotationMap();
        this.cmdMappers.initConfigMap();
        this.cmdMappers.printFuzzyMap();
        this.cmdMappers.resetCmdConfig();
    }
}

